/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraSearchParams;
import com.nvidia.cuvs.TieredIndex;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;

public class TieredIndexQuery {
    private TieredIndex.TieredIndexType indexType;
    private CagraSearchParams cagraSearchParameters;
    private List<Integer> mapping;
    private float[][] queryVectors;
    private int topK;
    private BitSet prefilter;
    private long numDocs;

    private TieredIndexQuery(TieredIndex.TieredIndexType indexType, CagraSearchParams cagraSearchParameters, List<Integer> mapping, float[][] queryVectors, int topK, BitSet prefilter, long numDocs) {
        this.indexType = indexType;
        this.cagraSearchParameters = cagraSearchParameters;
        this.mapping = mapping;
        this.queryVectors = queryVectors;
        this.topK = topK;
        this.prefilter = prefilter;
        this.numDocs = numDocs;
    }

    public TieredIndex.TieredIndexType getIndexType() {
        return this.indexType;
    }

    public CagraSearchParams getCagraSearchParameters() {
        return this.cagraSearchParameters;
    }

    public float[][] getQueryVectors() {
        return this.queryVectors;
    }

    public List<Integer> getMapping() {
        return this.mapping;
    }

    public int getTopK() {
        return this.topK;
    }

    public BitSet getPrefilter() {
        return this.prefilter;
    }

    public long getNumDocs() {
        return this.numDocs;
    }

    public String toString() {
        return "TieredIndexQuery [indexType=" + String.valueOf((Object)this.indexType) + ", cagraSearchParameters=" + String.valueOf(this.cagraSearchParameters) + ", queryVectors=" + Arrays.toString((Object[])this.queryVectors) + ", mapping=" + String.valueOf(this.mapping) + ", topK=" + this.topK + "]";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private TieredIndex.TieredIndexType indexType = TieredIndex.TieredIndexType.CAGRA;
        private CagraSearchParams cagraSearchParams;
        private float[][] queryVectors;
        private List<Integer> mapping;
        private int topK = 2;
        private BitSet prefilter;
        private long numDocs;

        public Builder withIndexType(TieredIndex.TieredIndexType indexType) {
            this.indexType = indexType;
            return this;
        }

        public Builder withSearchParams(CagraSearchParams cagraSearchParams) {
            this.cagraSearchParams = cagraSearchParams;
            return this;
        }

        public Builder withQueryVectors(float[][] queryVectors) {
            this.queryVectors = queryVectors;
            return this;
        }

        public Builder withMapping(List<Integer> mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder withPrefilter(BitSet prefilter, int numDocs) {
            this.prefilter = prefilter;
            this.numDocs = numDocs;
            return this;
        }

        public TieredIndexQuery build() {
            return new TieredIndexQuery(this.indexType, this.cagraSearchParams, this.mapping, this.queryVectors, this.topK, this.prefilter, this.numDocs);
        }
    }
}

