/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.spi;

import com.nvidia.cuvs.spi.CuVSProvider;
import com.nvidia.cuvs.spi.UnsupportedProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ServiceLoader;

public abstract class CuVSServiceProvider {
    public abstract CuVSProvider get(CuVSProvider var1);

    static class Holder {
        static final CuVSProvider INSTANCE = Holder.loadProvider();

        Holder() {
        }

        private static CuVSProvider loadProvider() {
            CuVSProvider builtinProvider = Holder.builtinProvider();
            return ServiceLoader.load(CuVSServiceProvider.class).findFirst().map(p -> p.get(builtinProvider)).orElse(builtinProvider);
        }

        static CuVSProvider builtinProvider() {
            if (Runtime.version().feature() > 21 && Holder.isLinuxAmd64()) {
                try {
                    Class<?> cls = Class.forName("com.nvidia.cuvs.spi.JDKProvider");
                    MethodHandle ctr = MethodHandles.lookup().findConstructor(cls, MethodType.methodType(Void.TYPE));
                    return ctr.invoke();
                }
                catch (Throwable e) {
                    throw new AssertionError((Object)e);
                }
            }
            return new UnsupportedProvider();
        }

        static boolean isLinuxAmd64() {
            String name = System.getProperty("os.name");
            return name.startsWith("Linux") && System.getProperty("os.arch").equals("amd64");
        }
    }
}

