/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.SecretsUtils;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.SecretReq;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;

@Command(name="add", description="Add secret for an application.")
public class SecretAdd
extends SecretsCommand {
    @Arguments(title="Secrets file", description="Secrets file", required=true)
    public String filePath;
    @Option(name={"-d"}, title="Description", description="Secret description", required=true)
    public String description;
    @Option(name={"-n"}, title="Secret name", description="Secret name. If not set, file name will be used.")
    public String secretName;

    @Override
    public void exec() {
        SecretsUtils.validateSecret(this.filePath, this.secretName, this.description);
        Path path = Paths.get(this.filePath, new String[0]);
        try {
            String secret = Base64.getEncoder().encodeToString(Files.readAllBytes(path));
            SecretReq secReq = new SecretReq(secret, this.description, null, 0L, "secret");
            this.secretName = this.secretName != null ? this.secretName : path.toFile().getName();
            Result<Void> result = this.secretsClient.createSecret(this.app.getName(), this.secretName, true, secReq);
            if (!result.isSuccessful()) {
                throw new SecretsProxyException(this, result.getErr());
            }
            StringBuilder buf = new StringBuilder();
            String lineSep = System.lineSeparator();
            buf.append(Color.sux(String.format("Secret '%s' added successfully for application %s.", this.secretName, this.app.getNsPath()))).append(lineSep).append(lineSep).append("Note the following:").append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Secret '%s' will be synced to '%s' environment computes in few seconds.", this.secretName, this.app.getNsPath().toLowerCase())))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Applications can access secret content by reading '/secrets/%s' file.", this.secretName)))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Secrets can be accessed only by the User/Group configured in 'secrets-client' component in the '%s' environment.", this.app.getNsPath().toLowerCase())))).append(lineSep).append("  ").append(Color.yellow(Color.dot("You may need to restart the application in order for the secret change to take effect."))).append(lineSep).append("  ").append(Color.yellow(Color.dot("For security reasons, secrets are never persisted on the disk and can only be accessed via the '/secrets' virtual memory file system."))).append(lineSep);
            Common.println(buf.toString());
        }
        catch (IOException e) {
            throw new SecretsProxyException(e);
        }
    }
}

