/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.io.IOException;

@Command(name="delete", description="Delete a secret.")
public class SecretDelete
extends SecretsCommand {
    @Arguments(title="Secret name", description="Secrets name", required=true)
    public String secretName;

    @Override
    public void exec() {
        try {
            String in = System.console().readLine(Color.warn("The delete secret operation is irrevocable. Do you want to proceed (y/n)? "), new Object[0]);
            if (in == null || !in.equalsIgnoreCase("y")) {
                throw new IllegalStateException("Exiting");
            }
            Result<Void> result = this.secretsClient.deleteSecret(this.app.getName(), this.secretName);
            if (!result.isSuccessful()) {
                throw new SecretsProxyException(this, result.getErr());
            }
            StringBuilder buf = new StringBuilder();
            String lineSep = System.lineSeparator();
            buf.append(Color.sux(String.format("Deleted the secret '%s' for application %s.", this.secretName, this.app.getNsPath()))).append(lineSep).append(lineSep).append("Note the following:").append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Secret '%s' will be removed from '%s' env computes in a few seconds.", this.secretName, this.app.getNsPath().toLowerCase())))).append(lineSep).append("  ").append(Color.yellow(Color.dot("You may need to restart the application in order for this secret change to take effect."))).append(lineSep).append("  ").append(Color.yellow(Color.dot("Delete secret operation is irrevocable!!"))).append(lineSep);
            Common.println(buf.toString());
        }
        catch (IOException e) {
            throw new SecretsProxyException(e);
        }
    }
}

