/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;

@Command(name="revert", description="Revert secret to the given version index.")
public class SecretRevert
extends SecretsCommand {
    @Arguments(title="Secret name", description="Secrets name", required=true)
    public String secretName;
    @Option(name={"-i"}, title="Version index", description="Secret version index.", required=true)
    public long version;

    @Override
    public void exec() {
        try {
            String in = System.console().readLine(Color.warn(String.format("You're going to reset the current version index of the secret to %d. Do you want to proceed (y/n)? ", this.version)), new Object[0]);
            if (in == null || !in.equalsIgnoreCase("y")) {
                throw new IllegalStateException("Exiting");
            }
            Result<Void> result = this.secretsClient.setSecretVersion(this.app.getName(), this.secretName, this.version);
            if (!result.isSuccessful()) {
                throw new SecretsProxyException(this, result.getErr());
            }
            StringBuilder buf = new StringBuilder();
            String lineSep = System.lineSeparator();
            buf.append(Color.sux(String.format("Reverted the secret '%s' version to '%d' for the application %s.", this.secretName, this.version, this.app.getNsPath()))).append(lineSep).append(lineSep).append("Note the following:").append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Secret '%s' version '%d' will be synced to '%s' environment computes in a few seconds.", this.secretName, this.version, this.app.getNsPath().toLowerCase())))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Applications can access secret content by reading '/secrets/%s' file.", this.secretName)))).append(lineSep).append("  ").append(Color.yellow(Color.dot("You may need to restart the application in order for this secret change to take effect."))).append(lineSep).append("  ").append(Color.yellow(Color.dot("You can revert back to a previous version of the secret. Check 'secrets help revert' for more details."))).append(lineSep);
            Common.println(buf.toString());
        }
        catch (IOException e) {
            throw new SecretsProxyException(e);
        }
    }
}

