/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.proxy.SecretsClient;
import com.oneops.secrets.proxy.SecretsUtils;
import com.oneops.secrets.proxy.model.App;
import com.oneops.secrets.utils.Platform;
import io.airlift.airline.Option;
import java.util.logging.Logger;

public abstract class SecretsCommand
implements Runnable {
    protected Logger log = Logger.getLogger(this.getClass().getSimpleName());
    @Option(name={"-a"}, title="Application name", description="OneOps application name (org_assembly_env), to which you have secret-admin access", required=true)
    String appName;
    @Option(name={"-u"}, title="User", description="User name")
    public String user = Platform.getUser();
    @Option(name={"-v"}, title="Verbose", description="Verbose mode")
    public boolean verbose;
    public App app;
    SecretsClient secretsClient;

    public abstract void exec();

    @Override
    public void run() {
        this.app = new App(this.appName);
        this.secretsClient = SecretsUtils.getSecretsClient(this);
        this.exec();
    }
}

