/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.config.CliConfig;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Command;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;

@Command(name="log", description="Tail (no-follow) secrets cli log file.")
public class TailLog
implements Runnable {
    @Override
    public void run() {
        Path logPath = Paths.get(CliConfig.logPath.toString().replace("%g", "0"), new String[0]);
        Common.println(Color.yellow("Log file : " + logPath));
        try (SeekableByteChannel sbc = Files.newByteChannel(logPath, StandardOpenOption.READ);){
            long fileSize = sbc.size();
            int tailSize = 2048;
            long pos = fileSize > (long)tailSize ? fileSize - (long)tailSize : 0L;
            ByteBuffer buf = ByteBuffer.allocate(tailSize);
            sbc.position(pos);
            while (sbc.read(buf) > 0) {
                buf.rewind();
                System.out.print(Charset.forName("UTF-8").decode(buf));
                buf.flip();
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Can't tail secrets cli log file.", ex);
        }
    }
}

