/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.config;

import com.oneops.secrets.config.SecretsProxyConfig;
import com.oneops.secrets.utils.Color;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.Attributes;

public class CliConfig {
    public static final SecretsProxyConfig secretsProxy;
    public static final Path logPath;
    public static final Attributes jarManifest;
    public static final String oneOpsBaseUrl;

    private CliConfig() {
    }

    private static Attributes readJarManifest() {
        try {
            URL res = CliConfig.class.getResource(CliConfig.class.getSimpleName() + ".class");
            URLConnection conn = res.openConnection();
            if (conn instanceof JarURLConnection) {
                return ((JarURLConnection)conn).getManifest().getMainAttributes();
            }
            return new Attributes(0);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static String banner() {
        return String.format("OneOps Secrets CLI: %s %n%s", Color.cyan("v" + jarManifest.getValue(Attributes.Name.IMPLEMENTATION_VERSION)), Color.gray("Built on " + jarManifest.getValue("Built-Date")));
    }

    public static String getVersion() {
        return jarManifest.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
    }

    static {
        Config appConfig = ConfigFactory.load("application");
        jarManifest = CliConfig.readJarManifest();
        secretsProxy = new SecretsProxyConfig(appConfig);
        logPath = Paths.get(appConfig.getString("log.dir"), appConfig.getString("log.filePattern"));
        oneOpsBaseUrl = appConfig.getString("oneops.baseUrl");
    }
}

