/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.config;

import com.oneops.secrets.config.KeyStoreConfig;
import com.typesafe.config.Config;

public class SecretsProxyConfig {
    private final String baseUrl;
    private final int timeout;
    private final KeyStoreConfig trustStore;

    public SecretsProxyConfig(String baseUrl, int timeout, KeyStoreConfig trustStore) {
        this.baseUrl = baseUrl;
        this.timeout = timeout;
        this.trustStore = trustStore;
    }

    public SecretsProxyConfig(Config config) {
        this.baseUrl = config.getString("secretsProxy.baseUrl");
        this.timeout = config.getInt("secretsProxy.timeout");
        this.trustStore = new KeyStoreConfig(config.getConfig("secretsProxy.truststore"));
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public KeyStoreConfig getTrustStore() {
        return this.trustStore;
    }

    public String toString() {
        return "SecretsProxyConfig{baseUrl='" + this.baseUrl + '\'' + ", timeout=" + this.timeout + ", trustStore=" + this.trustStore + '}';
    }
}

