/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.log;

import com.oneops.secrets.config.CliConfig;
import com.oneops.secrets.utils.Platform;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public class BriefLogFormatter
extends Formatter {
    private final MessageFormat messageFormat = new MessageFormat("{4,date,HH:mm:ss} [" + Platform.getUser() + "] {0} {1}{2}.{3}: {5}\n{6}");
    private static List<Logger> loggerRefs = new ArrayList<Logger>();
    private static boolean initialized = false;

    @Override
    public String format(@Nonnull LogRecord logRecord) {
        Object[] arguments = new Object[7];
        arguments[0] = logRecord.getThreadID();
        arguments[1] = "";
        if (logRecord.getLevel() == Level.SEVERE) {
            arguments[1] = " **ERROR** ";
        } else if (logRecord.getLevel() == Level.WARNING) {
            arguments[1] = " (warning) ";
        }
        String fullClassName = logRecord.getSourceClassName();
        int dollarIndex = fullClassName.indexOf(36);
        if (dollarIndex == -1) {
            dollarIndex = fullClassName.length();
        }
        String className = fullClassName.substring(fullClassName.lastIndexOf(46) + 1, dollarIndex);
        arguments[2] = className;
        arguments[3] = logRecord.getSourceMethodName();
        arguments[4] = new Date(logRecord.getMillis());
        String message = logRecord.getMessage();
        if (logRecord.getParameters() != null) {
            message = MessageFormat.format(logRecord.getMessage(), logRecord.getParameters());
        }
        arguments[5] = message;
        if (logRecord.getThrown() != null) {
            StringWriter result = new StringWriter();
            logRecord.getThrown().printStackTrace(new PrintWriter(result));
            arguments[6] = result.toString();
        } else {
            arguments[6] = "";
        }
        return this.messageFormat.format(arguments);
    }

    public static void init() throws IOException {
        Logger logger = Logger.getLogger("");
        if (!initialized) {
            File logDir = CliConfig.logPath.getParent().toFile();
            if (!logDir.exists()) {
                logDir.mkdirs();
            }
            FileHandler fileHandler = new FileHandler(CliConfig.logPath.toString(), 0xA00000, 2, true);
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new BriefLogFormatter());
            logger.setUseParentHandlers(false);
            logger.removeHandler(logger.getHandlers()[0]);
            logger.addHandler(fileHandler);
            loggerRefs.add(logger);
            logger.info("");
            logger.info(">>>>> Starting OneOps Secrets CLI... <<<<<");
            logger.info("Initialized the logger on" + DateTimeFormatter.RFC_1123_DATE_TIME.format(ZonedDateTime.now()));
            initialized = true;
        } else {
            logger.info("Logger is already initialized!");
        }
    }
}

