/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.proxy;

import com.oneops.secrets.config.CliConfig;
import com.oneops.secrets.config.KeyStoreConfig;
import com.oneops.secrets.config.SecretsProxyConfig;
import com.oneops.secrets.proxy.DateAdapter;
import com.oneops.secrets.proxy.SecretsProxy;
import com.oneops.secrets.proxy.model.AuthUser;
import com.oneops.secrets.proxy.model.Client;
import com.oneops.secrets.proxy.model.ErrorRes;
import com.oneops.secrets.proxy.model.Group;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.Secret;
import com.oneops.secrets.proxy.model.SecretContent;
import com.oneops.secrets.proxy.model.SecretReq;
import com.oneops.secrets.proxy.model.SecretVersion;
import com.oneops.secrets.proxy.model.TokenReq;
import com.oneops.secrets.proxy.model.TokenRes;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class SecretsClient {
    private Logger log = Logger.getLogger(this.getClass().getSimpleName());
    private SecretsProxyConfig config;
    private String authToken;
    private SecretsProxy secretsProxy;
    private Converter<ResponseBody, ErrorRes> errResConverter;

    public SecretsClient(SecretsProxyConfig config) throws GeneralSecurityException {
        String version = CliConfig.getVersion();
        this.log.info(String.format("Initializing the Secrets client %s for %s", version, config.getBaseUrl()));
        this.config = config;
        Moshi moshi = new Moshi.Builder().add(new DateAdapter()).build();
        HttpLoggingInterceptor logIntcp = new HttpLoggingInterceptor(s -> this.log.info(s));
        logIntcp.setLevel(HttpLoggingInterceptor.Level.BASIC);
        TrustManager[] trustManagers = this.getTrustManagers();
        SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
        sslContext.init(null, trustManagers, new SecureRandom());
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        int timeout = config.getTimeout();
        OkHttpClient okhttp = new OkHttpClient().newBuilder().sslSocketFactory(socketFactory, (X509TrustManager)trustManagers[0]).connectionSpecs(Collections.singletonList(ConnectionSpec.MODERN_TLS)).followSslRedirects(false).retryOnConnectionFailure(true).connectTimeout(timeout, TimeUnit.SECONDS).readTimeout(timeout, TimeUnit.SECONDS).writeTimeout(timeout, TimeUnit.SECONDS).addNetworkInterceptor(logIntcp).addInterceptor(chain -> {
            Request.Builder reqBuilder = chain.request().newBuilder().addHeader("Content-Type", "application/json").addHeader("User-Agent", "OneOpsSecretsCLI-" + version);
            if (this.authToken != null) {
                reqBuilder.addHeader("X-Authorization", "Bearer " + this.authToken);
            }
            return chain.proceed(reqBuilder.build());
        }).build();
        Retrofit retrofit = new Retrofit.Builder().baseUrl(config.getBaseUrl()).client(okhttp).addConverterFactory(MoshiConverterFactory.create(moshi)).build();
        this.secretsProxy = retrofit.create(SecretsProxy.class);
        this.errResConverter = retrofit.responseBodyConverter((Type)((Object)ErrorRes.class), new Annotation[0]);
    }

    public Result<TokenRes> genToken(String userName, String password) throws IOException {
        return this.genToken(userName, password, "prod");
    }

    public Result<TokenRes> genToken(String userName, String password, String domain) throws IOException {
        Result<TokenRes> res = this.exec(this.secretsProxy.token(new TokenReq(userName, password, domain)));
        if (res.isSuccessful()) {
            this.authToken = res.getBody().getAccessToken();
        }
        return res;
    }

    public Result<AuthUser> getAuthUser(String token) throws IOException {
        return this.exec(this.secretsProxy.getAuthUser("Bearer " + token));
    }

    public Result<Group> getGroupDetails(String group) throws IOException {
        return this.exec(this.secretsProxy.getGroupDetails(group));
    }

    public Result<List<Client>> getAllClients(String group) throws IOException {
        return this.exec(this.secretsProxy.getAllClients(group));
    }

    public Result<Client> getClientDetails(String group, String clientName) throws IOException {
        return this.exec(this.secretsProxy.getClientDetails(group, clientName));
    }

    public Result<List<Secret>> getAllSecrets(String group) throws IOException {
        return this.exec(this.secretsProxy.getAllSecrets(group));
    }

    public Result<List<String>> getAllSecretsExpiring(String group, long time) throws IOException {
        return this.exec(this.secretsProxy.getAllSecretsExpiring(group, time));
    }

    public Result<Void> createSecret(String group, String name, boolean createGroup, SecretReq secretReq) throws IOException {
        return this.exec(this.secretsProxy.createSecret(group, name, createGroup, secretReq));
    }

    public Result<Void> updateSecret(String group, String name, SecretReq secretReq) throws IOException {
        return this.exec(this.secretsProxy.updateSecret(group, name, secretReq));
    }

    public Result<Secret> getSecret(String group, String name) throws IOException {
        return this.exec(this.secretsProxy.getSecret(group, name));
    }

    public Result<List<Secret>> getSecretVersions(String group, String name) throws IOException {
        return this.exec(this.secretsProxy.getSecretVersions(group, name));
    }

    public Result<Void> deleteSecret(String group, String name) throws IOException {
        return this.exec(this.secretsProxy.deleteSecret(group, name));
    }

    public Result<Void> deleteClient(String group, String name) throws IOException {
        return this.exec(this.secretsProxy.deleteClient(group, name));
    }

    public Result<List<String>> deleteAllSecrets(String group) throws IOException {
        return this.exec(this.secretsProxy.deleteAllSecrets(group));
    }

    public Result<Void> setSecretVersion(String group, String name, long version) throws IOException {
        return this.exec(this.secretsProxy.setSecretVersion(group, name, new SecretVersion(version)));
    }

    public Result<SecretContent> getSecretContent(String group, String name) throws IOException {
        return this.exec(this.secretsProxy.getSecretContents(group, name));
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    private <T> Result<T> exec(Call<T> call) throws IOException {
        Response<T> res = call.execute();
        ErrorRes err = null;
        Object body = null;
        if (res.isSuccessful()) {
            body = res.body();
        } else if (res.errorBody() != null) {
            err = this.errResConverter.convert(res.errorBody());
        }
        return new Result<Object>(body, err, res.code(), res.isSuccessful());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private KeyStore keyStoreFromResource(KeyStoreConfig config) {
        try (InputStream ins = config.isFileResource() ? Files.newInputStream(Paths.get(config.getName(), new String[0]), new OpenOption[0]) : SecretsClient.class.getResourceAsStream(config.getName());){
            this.log.info("Loading the trust-store: " + config.getName());
            if (ins == null) {
                throw new IllegalStateException("Can't find the trust-store for OneOps Secrets.");
            }
            KeyStore ks = KeyStore.getInstance(config.getType());
            ks.load(ins, config.getPassword());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new IllegalStateException("Can't load the trust-store (" + config.getName() + ").", ex);
        }
    }

    private TrustManager[] getTrustManagers() throws GeneralSecurityException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(this.keyStoreFromResource(this.config.getTrustStore()));
        return trustManagerFactory.getTrustManagers();
    }
}

