/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.proxy;

import com.oneops.secrets.proxy.model.AuthUser;
import com.oneops.secrets.proxy.model.Client;
import com.oneops.secrets.proxy.model.Group;
import com.oneops.secrets.proxy.model.Secret;
import com.oneops.secrets.proxy.model.SecretContent;
import com.oneops.secrets.proxy.model.SecretReq;
import com.oneops.secrets.proxy.model.SecretVersion;
import com.oneops.secrets.proxy.model.TokenReq;
import com.oneops.secrets.proxy.model.TokenRes;
import java.util.List;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface SecretsProxy {
    public static final String prefix = "/v1/apps";
    public static final String authPrefix = "/v1/auth";

    @POST(value="/v1/auth/token")
    public Call<TokenRes> token(@Body TokenReq var1);

    @GET(value="/v1/auth/user")
    public Call<AuthUser> getAuthUser(@Header(value="X-Authorization") String var1);

    @GET(value="/v1/apps/{group}")
    public Call<Group> getGroupDetails(@Path(value="group") String var1);

    @GET(value="/v1/apps/{group}/clients")
    public Call<List<Client>> getAllClients(@Path(value="group") String var1);

    @GET(value="/v1/apps/{group}/clients/{client}")
    public Call<Client> getClientDetails(@Path(value="group") String var1, @Path(value="client") String var2);

    @DELETE(value="/v1/apps/{group}/clients/{client}")
    public Call<Void> deleteClient(@Path(value="group") String var1, @Path(value="client") String var2);

    @GET(value="/v1/apps/{group}/secrets")
    public Call<List<Secret>> getAllSecrets(@Path(value="group") String var1);

    @GET(value="/v1/apps/{group}/secrets/expiring/{time}")
    public Call<List<String>> getAllSecretsExpiring(@Path(value="group") String var1, @Path(value="time") long var2);

    @POST(value="/v1/apps/{group}/secrets/{name}")
    public Call<Void> createSecret(@Path(value="group") String var1, @Path(value="name") String var2, @Query(value="createGroup") boolean var3, @Body SecretReq var4);

    @PUT(value="/v1/apps/{group}/secrets/{name}")
    public Call<Void> updateSecret(@Path(value="group") String var1, @Path(value="name") String var2, @Body SecretReq var3);

    @GET(value="/v1/apps/{group}/secrets/{name}")
    public Call<Secret> getSecret(@Path(value="group") String var1, @Path(value="name") String var2);

    @GET(value="/v1/apps/{group}/secrets/{name}/versions")
    public Call<List<Secret>> getSecretVersions(@Path(value="group") String var1, @Path(value="name") String var2);

    @DELETE(value="/v1/apps/{group}/secrets/{name}")
    public Call<Void> deleteSecret(@Path(value="group") String var1, @Path(value="name") String var2);

    @DELETE(value="/v1/apps/{group}/secrets")
    public Call<List<String>> deleteAllSecrets(@Path(value="group") String var1);

    @POST(value="/v1/apps/{group}/secrets/{name}/setversion")
    public Call<Void> setSecretVersion(@Path(value="group") String var1, @Path(value="name") String var2, @Body SecretVersion var3);

    @POST(value="/v1/apps/{group}/secrets/{name}/contents")
    public Call<SecretContent> getSecretContents(@Path(value="group") String var1, @Path(value="name") String var2);
}

