/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.proxy.model;

import com.google.common.base.Strings;
import javax.annotation.Nonnull;

public class App {
    public static final String GROUP_SEP = "_";
    private final String name;
    private final String org;
    private final String assembly;
    private final String env;

    public App(@Nonnull String name) {
        this.name = name;
        String[] paths = name.split(GROUP_SEP);
        if (paths.length != 3 || Strings.isNullOrEmpty(paths[0]) || Strings.isNullOrEmpty(paths[1]) || Strings.isNullOrEmpty(paths[2])) {
            throw new IllegalArgumentException("Invalid application name: " + name + ". The format is 'org_assembly_env'.");
        }
        this.org = paths[0].trim();
        this.assembly = paths[1].trim();
        this.env = paths[2].trim();
    }

    public String getName() {
        return this.name;
    }

    public String getOrg() {
        return this.org;
    }

    public String getOrgNsPath() {
        return String.format("/%s", this.org);
    }

    public String getAssemblyNsPath() {
        return String.format("/%s/%s", this.org, this.assembly);
    }

    public String getAssembly() {
        return this.assembly;
    }

    public String getEnv() {
        return this.env;
    }

    public String getNsPath() {
        return String.format("/%s/%s/%s", this.org, this.assembly, this.env);
    }

    public String getTeamsUrl(String baseUrl) {
        return String.format("%s/%s/assemblies/%s#teams", baseUrl, this.org, this.assembly);
    }

    public String toString() {
        return "App{name='" + this.name + '\'' + ", org='" + this.org + '\'' + ", assembly='" + this.assembly + '\'' + ", env='" + this.env + '\'' + '}';
    }
}

