/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.proxy.model;

import com.oneops.secrets.asciitable.Column;
import com.oneops.secrets.asciitable.Table;
import com.oneops.secrets.proxy.SecretsUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;

public class Client {
    private final String name;
    private final String description;
    private final long createdAtSeconds;
    private final long updatedAtSeconds;
    private final String createdBy;
    private final String updatedBy;
    private final Long lastSeenSeconds;

    public Client(String name, String description, long createdAtSeconds, long updatedAtSeconds, String createdBy, String updatedBy, Long lastSeenSeconds) {
        this.name = name;
        this.description = description;
        this.createdAtSeconds = createdAtSeconds;
        this.updatedAtSeconds = updatedAtSeconds;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
        this.lastSeenSeconds = lastSeenSeconds;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public long getCreatedAtSeconds() {
        return this.createdAtSeconds;
    }

    public long getUpdatedAtSeconds() {
        return this.updatedAtSeconds;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public Long getLastSeenSeconds() {
        return this.lastSeenSeconds;
    }

    public String toString() {
        return "Client{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", createdAtSeconds=" + this.createdAtSeconds + ", updatedAtSeconds=" + this.updatedAtSeconds + ", createdBy='" + this.createdBy + '\'' + ", updatedBy='" + this.updatedBy + '\'' + ", lastSeenSeconds=" + this.lastSeenSeconds + '}';
    }

    public static String getTable(List<Client> clients) {
        List columns = Arrays.asList(new Column("Client Name").with(Client::getName), new Column("Created By").with(Client::getCreatedBy));
        return String.format("%s%s", System.lineSeparator(), Table.getTable(clients, columns));
    }

    public static String getTable(Client clientDetails) {
        String[] header = new String[]{"Client Name", clientDetails.name};
        String[][] data = new String[][]{{"Description", clientDetails.description}, {"Created By", clientDetails.createdBy}, {"Created At", Client.time(clientDetails.createdAtSeconds)}, {"Updated By", clientDetails.updatedBy}, {"Updated At", Client.time(clientDetails.updatedAtSeconds)}, {"Last seen", Client.time(clientDetails.lastSeenSeconds)}};
        return String.format("%s%s", System.lineSeparator(), Table.getTable(header, data));
    }

    private static String time(long atSeconds) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(atSeconds), ZoneId.systemDefault()).format(SecretsUtils.dateFormatter);
    }
}

