/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.proxy.model;

import com.oneops.secrets.asciitable.Column;
import com.oneops.secrets.asciitable.Table;
import com.oneops.secrets.proxy.SecretsUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Secret {
    public static final String USERID_METADATA = "_userId";
    public static final String DESC_METADATA = "_desc";
    public static final String FILENAME_METADATA = "filename";
    private final String name;
    private final String description;
    private final String checksum;
    private final long createdAtSeconds;
    private final long updatedAtSeconds;
    private final String createdBy;
    private final String updatedBy;
    private final Map<String, String> metadata;
    private final String type;
    private final long expiry;
    private final long version;

    public Secret(String name, String description, String checksum, long createdAtSeconds, long updatedAtSeconds, String createdBy, String updatedBy, Map<String, String> metadata, String type, long expiry, long version) {
        this.name = name;
        this.description = description;
        this.checksum = checksum;
        this.createdAtSeconds = createdAtSeconds;
        this.updatedAtSeconds = updatedAtSeconds;
        this.createdBy = createdBy;
        this.updatedBy = updatedBy;
        this.metadata = metadata;
        this.type = type;
        this.expiry = expiry;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public long getCreatedAtSeconds() {
        return this.createdAtSeconds;
    }

    public long getUpdatedAtSeconds() {
        return this.updatedAtSeconds;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getUpdatedBy() {
        return this.updatedBy;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public String getType() {
        return this.type;
    }

    public long getExpiry() {
        return this.expiry;
    }

    public long getVersion() {
        return this.version;
    }

    public String toString() {
        return "Secret{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", checksum='" + this.checksum + '\'' + ", createdAtSeconds=" + this.createdAtSeconds + ", updatedAtSeconds=" + this.updatedAtSeconds + ", createdBy='" + this.createdBy + '\'' + ", updatedBy='" + this.updatedBy + '\'' + ", metadata=" + this.metadata + ", type='" + this.type + '\'' + ", expiry=" + this.expiry + ", version=" + this.version + '}';
    }

    public static String getTable(List<Secret> secrets) {
        List columns = Arrays.asList(new Column("Secret Name").with(Secret::getName), new Column("Description").with(Secret::getDescription), new Column("UserID").with(s -> s.getMetadata().getOrDefault(USERID_METADATA, "N/A")), new Column("Checksum").with(s -> s.checksum.substring(0, 6)), new Column("Expiry").with(s -> Secret.expiry(s.expiry)), new Column("Version").with(s -> String.valueOf(s.getVersion())));
        return String.format("%s%s", System.lineSeparator(), Table.getTable(secrets, columns));
    }

    public static String getVersionTable(List<Secret> secrets) {
        List columns = Arrays.asList(new Column("Secret Name").with(Secret::getName), new Column("Version").with(s -> String.valueOf(s.getVersion())), new Column("Description").with(s -> s.getMetadata().getOrDefault(DESC_METADATA, "N/A")), new Column("UserID").with(s -> s.getMetadata().getOrDefault(USERID_METADATA, "N/A")), new Column("Checksum").with(s -> s.checksum.substring(0, 6)), new Column("Expiry").with(s -> Secret.expiry(s.expiry)));
        return String.format("%s%s", System.lineSeparator(), Table.getTable(secrets, columns));
    }

    public static String getTable(Secret secretDetails) {
        String[] header = new String[]{"Secret Name", secretDetails.name};
        String[][] data = new String[][]{{"Description", secretDetails.description}, {"Created By", secretDetails.createdBy}, {"Created At", Secret.time(secretDetails.createdAtSeconds)}, {"Updated By", secretDetails.getMetadata().getOrDefault(USERID_METADATA, "N/A")}, {"Updated At", Secret.time(secretDetails.updatedAtSeconds)}, {"Checksum", secretDetails.checksum}, {"Type", secretDetails.type}, {"Expiry", Secret.expiry(secretDetails.expiry)}, {"Version", String.valueOf(secretDetails.version)}};
        return String.format("%s%s", System.lineSeparator(), Table.getTable(header, data));
    }

    private static String time(long atSeconds) {
        return ZonedDateTime.ofInstant(Instant.ofEpochSecond(atSeconds), ZoneId.systemDefault()).format(SecretsUtils.dateFormatter);
    }

    private static String expiry(long atMilli) {
        if (atMilli != 0L) {
            return ZonedDateTime.ofInstant(Instant.ofEpochMilli(atMilli), ZoneId.systemDefault()).format(SecretsUtils.dateFormatter);
        }
        return "Never";
    }
}

