/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.utils;

import com.oneops.secrets.utils.Arch;
import com.oneops.secrets.utils.OS;

public class Platform {
    private static final OS os;
    private static final Arch arch;
    private static final String user;
    private static final String userHome;
    private static final boolean isUnix;

    private Platform() {
    }

    public static OS getOs() {
        return os;
    }

    public static Arch getArch() {
        return arch;
    }

    public static String getUser() {
        return user;
    }

    public static String getUserHome() {
        return userHome;
    }

    public static boolean isUnix() {
        return isUnix;
    }

    static {
        user = System.getProperty("user.name");
        userHome = System.getProperty("user.home");
        String osArch = System.getProperty("os.arch").toLowerCase();
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.matches(OS.mac.getType())) {
            os = OS.mac;
        } else if (osName.startsWith(OS.linux.getType())) {
            os = OS.linux;
        } else if (osName.startsWith(OS.windows.getType())) {
            os = OS.windows;
        } else if (osName.startsWith(OS.freebsd.getType())) {
            os = OS.freebsd;
        } else {
            throw new IllegalStateException("Unsupported OS " + osName);
        }
        if (osArch.matches(Arch.x86.getType())) {
            arch = Arch.x86;
        } else if (osArch.matches(Arch.x86_64.getType())) {
            arch = Arch.x86_64;
        } else {
            throw new IllegalStateException("Unsupported OS Arch " + osArch);
        }
        isUnix = os != OS.windows;
    }
}

