/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets;

import com.oneops.secrets.command.ClientList;
import com.oneops.secrets.command.Details;
import com.oneops.secrets.command.SecretAdd;
import com.oneops.secrets.command.SecretDelete;
import com.oneops.secrets.command.SecretGet;
import com.oneops.secrets.command.SecretList;
import com.oneops.secrets.command.SecretRevert;
import com.oneops.secrets.command.SecretUpdate;
import com.oneops.secrets.command.SecretVersions;
import com.oneops.secrets.command.TailLog;
import com.oneops.secrets.command.Version;
import com.oneops.secrets.config.CliConfig;
import com.oneops.secrets.log.BriefLogFormatter;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.App;
import com.oneops.secrets.proxy.model.ErrorRes;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import com.oneops.secrets.utils.Platform;
import io.airlift.airline.Cli;
import io.airlift.airline.Help;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Main {
    private static Logger log;

    private static void init() throws IOException {
        BriefLogFormatter.init();
        log = Logger.getLogger("Secrets-CLI");
        log.info("Initializing secrets cli app.");
    }

    public static void main(String[] args) {
        try {
            Main.init();
            Cli.CliBuilder<SecretAdd> builder = Cli.builder("secrets").withDescription("CLI for managing OneOps application secrets").withDefaultCommand(Help.class).withCommands(SecretAdd.class, SecretUpdate.class, SecretDelete.class, SecretGet.class, SecretVersions.class, SecretList.class, SecretRevert.class, ClientList.class, Details.class, Version.class, TailLog.class, Help.class);
            Cli<SecretAdd> cliParser = builder.build();
            ((Runnable)cliParser.parse(args)).run();
            System.exit(0);
        }
        catch (SecretsProxyException e) {
            Main.printError(e);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "Error while running the command.", t);
            Common.println(Color.err(t.getMessage()));
            Common.println("See " + Color.bold("'secrets help'"));
        }
        System.exit(-1);
    }

    private static void printError(SecretsProxyException ex) {
        log.log(Level.SEVERE, "Error while running the command.", ex);
        StringBuilder buf = new StringBuilder();
        String lineSep = System.lineSeparator();
        if (ex.getErr() != null && ex.getCmd() != null) {
            App app = ex.getCmd().app;
            ErrorRes err = ex.getErr();
            buf.append(Color.err(err.getMessage()));
            switch (err.getStatus()) {
                case 403: {
                    buf.append(lineSep).append(lineSep).append("Verify the following:").append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("OneOps assembly '%s' exists.", app.getAssemblyNsPath().toLowerCase())))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("User '%s' is part of the organization '%s'.", Platform.getUser(), app.getOrg())))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("User '%s' is part of the 'secrets-admin' or the 'secrets-admin-%s' team in the organization.", Platform.getUser(), app.getAssembly().toLowerCase())))).append(lineSep).append("    ").append(Color.yellow(String.format("Contact an administrator of the organization '%s' to create the team(s), if it doesn't exist.", app.getOrg()))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Secrets admin team that you are a part of is assigned to the assembly '%s'.", app.getAssembly())))).append(lineSep).append("    ").append(Color.yellow(app.getTeamsUrl(CliConfig.oneOpsBaseUrl)));
                    break;
                }
            }
        } else {
            buf.append(Color.err(ex.getMessage()));
        }
        Common.println(buf.toString());
    }
}

