/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.asciitable;

import com.oneops.secrets.asciitable.Align;
import com.oneops.secrets.asciitable.Column;
import com.oneops.secrets.utils.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class Table {
    public static <T> String getTable(Collection<T> objects, List<Column.Data<T>> columns) {
        String[][] data = new String[objects.size()][];
        Iterator<T> iter = objects.iterator();
        for (int i = 0; i < objects.size(); ++i) {
            T object = iter.next();
            data[i] = new String[columns.size()];
            for (int j = 0; j < columns.size(); ++j) {
                data[i][j] = columns.get((int)j).getter.apply(object);
            }
        }
        Column[] rawColumns = columns.stream().map(c -> c.column).collect(Collectors.toList()).toArray(new Column[columns.size()]);
        return Table.getTable(rawColumns, data);
    }

    public static String getTable(String[] header, String[][] data) {
        Column[] headerCol = Arrays.asList(header).stream().map(h2 -> new Column((String)h2)).collect(Collectors.toList()).toArray(new Column[header.length]);
        return Table.getTable(headerCol, data);
    }

    public static String getTable(Column[] headerObjs, String[][] data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Data is null or empty. Provide valid data.");
        }
        StringBuilder tableBuf = new StringBuilder();
        String[] header = Table.getHeaders(headerObjs);
        int colCount = Table.getMaxColumns(header, data);
        List<Integer> colMaxLenList = Table.getMaxColLengths(colCount, header, data);
        if (header != null && header.length > 0) {
            tableBuf.append(Table.getRowLineBuf(colCount, colMaxLenList, data));
            tableBuf.append(Color.bold(Table.getRowDataBuf(colCount, colMaxLenList, header, headerObjs, true)));
        }
        tableBuf.append(Table.getRowLineBuf(colCount, colMaxLenList, data));
        String[] rowData = null;
        for (int i = 0; i < data.length; ++i) {
            rowData = new String[colCount];
            for (int j = 0; j < colCount; ++j) {
                rowData[j] = j < data[i].length ? data[i][j] : "";
            }
            tableBuf.append(Table.getRowDataBuf(colCount, colMaxLenList, rowData, headerObjs, false));
        }
        tableBuf.append(Table.getRowLineBuf(colCount, colMaxLenList, data));
        return tableBuf.toString();
    }

    private static String getRowDataBuf(int colCount, List<Integer> colMaxLenList, String[] row, Column[] headerObjs, boolean isHeader) {
        StringBuilder rowBuilder = new StringBuilder();
        String formattedData = null;
        for (int i = 0; i < colCount; ++i) {
            Align align;
            Align align2 = align = isHeader ? Align.HEADER_DEFAULT : Align.DATA_DEFAULT;
            if (headerObjs != null && i < headerObjs.length) {
                align = isHeader ? headerObjs[i].headerAlign : headerObjs[i].dataAlign;
            }
            formattedData = i < row.length ? row[i] : "";
            String fmtString = Table.getFormattedData(colMaxLenList.get(i), formattedData, align);
            formattedData = "| " + (isHeader ? Color.bold(Color.green(fmtString)) : fmtString) + " ";
            if (i + 1 == colCount) {
                formattedData = formattedData + "|";
            }
            rowBuilder.append(formattedData);
        }
        return rowBuilder.append("\n").toString();
    }

    private static String getFormattedData(int maxLength, String data, Align align) {
        if (data.length() > maxLength) {
            return data;
        }
        boolean toggle = true;
        while (data.length() < maxLength) {
            if (align == Align.LEFT) {
                data = data + " ";
                continue;
            }
            if (align == Align.RIGHT) {
                data = " " + data;
                continue;
            }
            if (align != Align.CENTER) continue;
            if (toggle) {
                data = " " + data;
                toggle = false;
                continue;
            }
            data = data + " ";
            toggle = true;
        }
        return data;
    }

    private static String getRowLineBuf(int colCount, List<Integer> colMaxLenList, String[][] data) {
        StringBuilder rowBuilder = new StringBuilder();
        int colWidth = 0;
        for (int i = 0; i < colCount; ++i) {
            colWidth = colMaxLenList.get(i) + 3;
            for (int j = 0; j < colWidth; ++j) {
                if (j == 0) {
                    rowBuilder.append("+");
                    continue;
                }
                if (i + 1 == colCount && j + 1 == colWidth) {
                    rowBuilder.append("-+");
                    continue;
                }
                rowBuilder.append("-");
            }
        }
        return rowBuilder.append("\n").toString();
    }

    private static int getMaxItemLength(List<String> colData) {
        int maxLength = 0;
        for (int i = 0; i < colData.size(); ++i) {
            maxLength = Math.max(colData.get(i).length(), maxLength);
        }
        return maxLength;
    }

    private static int getMaxColumns(String[] header, String[][] data) {
        int maxColumns = 0;
        for (int i = 0; i < data.length; ++i) {
            maxColumns = Math.max(data[i].length, maxColumns);
        }
        maxColumns = Math.max(header.length, maxColumns);
        return maxColumns;
    }

    private static List<Integer> getMaxColLengths(int colCount, String[] header, String[][] data) {
        ArrayList<Integer> colMaxLenList = new ArrayList<Integer>(colCount);
        ArrayList<String> colData = null;
        for (int i = 0; i < colCount; ++i) {
            colData = new ArrayList<String>();
            if (header != null && i < header.length) {
                colData.add(header[i]);
            }
            for (int j = 0; j < data.length; ++j) {
                if (i < data[j].length) {
                    colData.add(data[j][i]);
                    continue;
                }
                colData.add("");
            }
            int maxLength = Table.getMaxItemLength(colData);
            colMaxLenList.add(maxLength);
        }
        return colMaxLenList;
    }

    private static String[] getHeaders(Column[] headerObjs) {
        String[] header = new String[]{};
        if (headerObjs != null && headerObjs.length > 0) {
            header = new String[headerObjs.length];
            for (int i = 0; i < headerObjs.length; ++i) {
                header[i] = headerObjs[i].header;
            }
        }
        return header;
    }
}

