/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.Client;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Command;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

@Command(name="clients", description="Show all clients for the application.")
public class ClientList
extends SecretsCommand {
    @Override
    public void exec() {
        block6: {
            try {
                Result<List<Client>> result = this.secretsClient.getAllClients(this.app.getName());
                if (result.isSuccessful()) {
                    List<Client> clients = result.getBody();
                    String lineSep = System.lineSeparator();
                    Common.println(Color.sux(String.format("%d clients (computes) are registered for the application %s.", clients.size(), this.app.getNsPath())));
                    if (clients.size() != 0) {
                        int displayLimit = 50;
                        if (clients.size() > displayLimit) {
                            Common.println(Color.dim("Showing first " + displayLimit + " clients."));
                            clients = clients.stream().limit(displayLimit).collect(Collectors.toList());
                        }
                        Common.println(Client.getTable(clients));
                        Common.println(String.format("To get the client details, run %s", Color.bold("secrets details  -a <app name> -client <client name>")));
                    } else {
                        StringBuilder buf = new StringBuilder();
                        buf.append(lineSep).append("Verify the following:").append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("'secrets-client' component is added to the relevant platforms of the assembly '%s'.", this.app.getAssembly())))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Completed the deployment of the '%s' application to the environment.", this.app.getNsPath()))));
                        Common.println(buf.toString());
                    }
                    break block6;
                }
                throw new SecretsProxyException(this, result.getErr());
            }
            catch (IOException ex) {
                throw new SecretsProxyException(ex);
            }
        }
    }
}

