/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.google.common.base.Strings;
import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.Client;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.Secret;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;

@Command(name="details", description="Get a client/secret details of an application.")
public class Details
extends SecretsCommand {
    @Option(name={"-client"}, title="Client name", description="Secrets client name.")
    public String client;
    @Option(name={"-secret"}, title="Secret name", description="Secret name.")
    public String secret;

    @Override
    public void exec() {
        boolean clientPresent;
        boolean secretPresent = !Strings.isNullOrEmpty(this.secret);
        boolean bl = clientPresent = !Strings.isNullOrEmpty(this.client);
        if (secretPresent ^ clientPresent) {
            try {
                if (secretPresent) {
                    Result<Secret> secRes = this.secretsClient.getSecret(this.app.getName(), this.secret);
                    if (secRes.isSuccessful()) {
                        Secret secret = secRes.getBody();
                        Common.println(Secret.getTable(secret));
                    }
                    throw new SecretsProxyException(this, secRes.getErr());
                }
                Result<Client> clRes = this.secretsClient.getClientDetails(this.app.getName(), this.client);
                if (clRes.isSuccessful()) {
                    Client client = clRes.getBody();
                    Common.println(Client.getTable(client));
                }
                throw new SecretsProxyException(this, clRes.getErr());
            }
            catch (IOException ex) {
                throw new SecretsProxyException(ex);
            }
        } else {
            throw new IllegalArgumentException("Either client or secret name (not both) should present.");
        }
    }
}

