/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.SecretContent;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Base64;

@Command(name="get", description="Retrieve a secret from the vault.")
public class SecretGet
extends SecretsCommand {
    @Arguments(title="Secret name", description="Secrets name", required=true)
    public String secretName;
    @Option(name={"-s"}, title="Save", description="Save to file. Defaults to false.")
    public boolean save = false;

    @Override
    public void exec() {
        block5: {
            try {
                Result<SecretContent> result = this.secretsClient.getSecretContent(this.app.getName(), this.secretName);
                if (result.isSuccessful()) {
                    byte[] content = Base64.getDecoder().decode(result.getBody().getContent());
                    if (this.save) {
                        Path path = this.save(this.secretName, content);
                        Common.println(Color.sux(String.format("Secret '%s' retrieved to %s", this.secretName, path.toAbsolutePath())));
                    } else {
                        Common.println(String.format("%s%s", System.lineSeparator(), Color.cyan(new String(content))));
                    }
                    break block5;
                }
                throw new SecretsProxyException(this, result.getErr());
            }
            catch (IOException e) {
                throw new SecretsProxyException(e);
            }
        }
    }

    private Path save(String name, byte[] content) throws IOException {
        String in;
        Path path = Paths.get(name, new String[0]);
        if (path.toFile().exists() && ((in = System.console().readLine(Color.warn("File " + path + " exists. Do you want to overwrite (y/n)? "), new Object[0])) == null || !in.equalsIgnoreCase("y"))) {
            throw new IllegalStateException("Exiting");
        }
        return Files.write(path, content, StandardOpenOption.CREATE);
    }
}

