/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.Secret;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Command;
import java.io.IOException;
import java.util.List;

@Command(name="list", description="List all secrets for the application.")
public class SecretList
extends SecretsCommand {
    @Override
    public void exec() {
        block4: {
            try {
                Result<List<Secret>> result = this.secretsClient.getAllSecrets(this.app.getName());
                if (result.isSuccessful()) {
                    List<Secret> secrets = result.getBody();
                    Common.println(Color.sux(String.format("%d secrets are stored for the application environments: %s", secrets.size(), this.app.getNsPath())));
                    if (secrets.size() > 0) {
                        Common.println(Secret.getTable(secrets));
                        Common.println(String.format("To get the secret details, run %s", Color.bold("secrets details  -a <app name> -secret <secret name>")));
                    }
                    break block4;
                }
                throw new SecretsProxyException(this, result.getErr());
            }
            catch (IOException ex) {
                throw new SecretsProxyException(ex);
            }
        }
    }
}

