/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.SecretsUtils;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.SecretReq;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import io.airlift.airline.Option;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;

@Command(name="update", description="Update an existing secret.")
public class SecretUpdate
extends SecretsCommand {
    @Arguments(title="Secrets file", description="Secrets file", required=true)
    public String filePath;
    @Option(name={"-d"}, title="Description", description="Secret description", required=true)
    public String description;
    @Option(name={"-n"}, title="Secret name", description="Secret name. If not set, file name will be used.")
    public String secretName;

    @Override
    public void exec() {
        SecretsUtils.validateSecret(this.filePath, this.secretName, this.description);
        Path path = Paths.get(this.filePath, new String[0]);
        try {
            String secret = Base64.getEncoder().encodeToString(Files.readAllBytes(path));
            SecretReq secReq = new SecretReq(secret, this.description, null, 0L, "secret");
            String in = System.console().readLine(Color.warn("You are going to update an existing secret. Do you want to proceed (y/n)? "), new Object[0]);
            if (in == null || !in.equalsIgnoreCase("y")) {
                throw new IllegalStateException("Exiting");
            }
            this.secretName = this.secretName != null ? this.secretName : path.toFile().getName();
            Result<Void> result = this.secretsClient.updateSecret(this.app.getName(), this.secretName, secReq);
            if (!result.isSuccessful()) {
                throw new SecretsProxyException(this, result.getErr());
            }
            StringBuilder buf = new StringBuilder();
            String lineSep = System.lineSeparator();
            buf.append(Color.sux(String.format("Updated the secret '%s' for application %s.", this.secretName, this.app.getNsPath()))).append(lineSep).append(lineSep).append("Note the following:").append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Secret '%s' will be synced to '%s' environment computes in a few seconds.", this.secretName, this.app.getNsPath().toLowerCase())))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Applications can access secret content by reading the '/secrets/%s' file.", this.secretName)))).append(lineSep).append("  ").append(Color.yellow(Color.dot(String.format("Secrets can be accessed only by the User/Group configured in the 'secrets-client' component in the environment '%s'.", this.app.getNsPath().toLowerCase())))).append(lineSep).append("  ").append(Color.yellow(Color.dot("You may need to restart the application in order for this secret change to take effect."))).append(lineSep).append("  ").append(Color.yellow(Color.dot("You can revert back to a previous version of the secret. Check 'secrets help revert' for more details."))).append(lineSep);
            Common.println(buf.toString());
        }
        catch (IOException e) {
            throw new SecretsProxyException(e);
        }
    }
}

