/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.Secret;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Common;
import io.airlift.airline.Arguments;
import io.airlift.airline.Command;
import java.io.IOException;
import java.util.List;

@Command(name="versions", description="Retrieve versions of a secret, sorted from newest to oldest update time.")
public class SecretVersions
extends SecretsCommand {
    @Arguments(title="Secret name", description="Secrets name", required=true)
    public String secretName;

    @Override
    public void exec() {
        block4: {
            try {
                Result<List<Secret>> result = this.secretsClient.getSecretVersions(this.app.getName(), this.secretName);
                if (result.isSuccessful()) {
                    List<Secret> secrets = result.getBody();
                    Common.println(Color.sux(String.format("Retrieved %d version(s) of secret '%s' for the application environment: %s", secrets.size(), this.secretName, this.app.getNsPath())));
                    if (secrets.size() > 0) {
                        Common.println(Secret.getVersionTable(secrets));
                    }
                    break block4;
                }
                throw new SecretsProxyException(this, result.getErr());
            }
            catch (IOException e) {
                throw new SecretsProxyException(e);
            }
        }
    }
}

