/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.command;

import com.oneops.secrets.config.AuthDomain;
import com.oneops.secrets.proxy.SecretsClient;
import com.oneops.secrets.proxy.SecretsUtils;
import com.oneops.secrets.proxy.model.App;
import com.oneops.secrets.utils.Platform;
import io.airlift.airline.Option;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class SecretsCommand
implements Runnable {
    protected Logger log = Logger.getLogger(this.getClass().getSimpleName());
    @Option(name={"-a"}, title="Application name", description="OneOps application name (org_assembly_env), to which you have secret-admin access", required=true)
    String appName;
    @Option(name={"-u"}, title="User", description="User name")
    public String user = Platform.getUser();
    @Option(name={"-m"}, title="Domain", description="Auth Domain. Default domain is 'prod'")
    public String domain = "prod";
    @Option(name={"-v"}, title="Verbose", description="Verbose mode")
    public boolean verbose;
    public App app;
    SecretsClient secretsClient;

    public abstract void exec();

    @Override
    public void run() {
        this.validateAuthDomain();
        this.app = new App(this.appName);
        this.secretsClient = SecretsUtils.getSecretsClient(this);
        this.exec();
    }

    public String authTokenName() {
        return String.format("%s-%s.token", this.user, this.domain);
    }

    private void validateAuthDomain() {
        try {
            AuthDomain.valueOf(this.domain.toUpperCase());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid auth domain " + this.domain + ". Valid domains are " + Arrays.stream(AuthDomain.values()).map(AuthDomain::getType).collect(Collectors.joining(", ")));
        }
    }
}

