/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.config;

import com.typesafe.config.Config;

public class KeyStoreConfig {
    private static final String FS_PREFIX = "file:";
    private final String name;
    private final String type;
    private final char[] password;
    private final boolean fileResource;

    public KeyStoreConfig(Config config) {
        String path = config.getString("path");
        this.type = config.getString("type");
        this.password = config.getString("password").toCharArray();
        this.name = path.replaceFirst(FS_PREFIX, "");
        this.fileResource = path.toLowerCase().startsWith(FS_PREFIX);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public char[] getPassword() {
        return this.password;
    }

    public boolean isFileResource() {
        return this.fileResource;
    }

    public String toString() {
        return "KeyStoreConfig{name='" + this.name + '\'' + ", type='" + this.type + '\'' + ", fileResource=" + this.fileResource + '}';
    }
}

