/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.proxy;

import com.google.common.base.Strings;
import com.oneops.secrets.command.SecretsCommand;
import com.oneops.secrets.config.CliConfig;
import com.oneops.secrets.proxy.SecretsClient;
import com.oneops.secrets.proxy.SecretsProxyException;
import com.oneops.secrets.proxy.model.AuthUser;
import com.oneops.secrets.proxy.model.Result;
import com.oneops.secrets.proxy.model.TokenRes;
import com.oneops.secrets.utils.Color;
import com.oneops.secrets.utils.Platform;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.GeneralSecurityException;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SecretsUtils {
    private static Logger log = Logger.getLogger(SecretsUtils.class.getSimpleName());
    private static Path secretsPath = Paths.get(Platform.getUserHome(), ".secrets-cli");
    public static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z");

    public static SecretsClient getSecretsClient(SecretsCommand cmd) {
        try {
            SecretsClient secretsClient = new SecretsClient(CliConfig.secretsProxy);
            String currentUser = cmd.user;
            String bearerToken = SecretsUtils.readToken(cmd.authTokenName());
            if (bearerToken != null) {
                log.info("Using bearer token from secrets path.");
                Result<AuthUser> authUser = secretsClient.getAuthUser(bearerToken);
                if (authUser.isSuccessful() && currentUser.equalsIgnoreCase(authUser.getBody().getUserName())) {
                    secretsClient.setAuthToken(bearerToken);
                    return secretsClient;
                }
            }
            log.warning("Bearer token is not valid. Generating new token.");
            String password = String.valueOf(SecretsUtils.readPassword(currentUser));
            Result<TokenRes> genToken = secretsClient.genToken(currentUser, password, cmd.domain);
            if (genToken.isSuccessful()) {
                SecretsUtils.writeToken(cmd.authTokenName(), genToken.getBody().getAccessToken());
                return secretsClient;
            }
            throw new SecretsProxyException(cmd, genToken.getErr());
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new SecretsProxyException("Error occurred talking to the OneOps Secret Proxy. See 'secrets log' for more details.", ex);
        }
    }

    public static void validateSecret(String path, String name, String desc) {
        File secretsFile = Paths.get(path, new String[0]).toFile();
        if (!secretsFile.exists() || secretsFile.isDirectory()) {
            throw new IllegalArgumentException(String.format("Secret '%s' does not exist or is a directory.", path));
        }
        long maxSize = CliConfig.secretsProxy.getSecretMaxSize();
        if (secretsFile.length() > maxSize) {
            throw new IllegalArgumentException(String.format("Secret '%s' is too large. Only up to %s per secret is allowed.", path, SecretsUtils.binaryPrefix(maxSize)));
        }
        if (Strings.isNullOrEmpty(desc)) {
            throw new IllegalArgumentException(String.format("Secret '%s' description can't be empty.", path));
        }
        if (desc.length() > 64) {
            throw new IllegalArgumentException(String.format("Secret '%s' description is too long. A maximum of 64 characters is allowed.", path));
        }
        if (name != null && name.trim().isEmpty()) {
            throw new IllegalArgumentException("Secret name is empty.");
        }
    }

    @Nullable
    private static String readToken(String tokenName) {
        String token = null;
        try {
            Path tokenPath = secretsPath.resolve(tokenName);
            token = new String(Files.readAllBytes(tokenPath));
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Can't read the token: " + ex.getMessage());
        }
        return token;
    }

    private static void writeToken(String tokenName, String token) {
        try {
            secretsPath.toFile().mkdir();
            Path tokenPath = secretsPath.resolve(tokenName);
            Files.write(tokenPath, token.getBytes(), StandardOpenOption.CREATE);
        }
        catch (IOException ex) {
            log.log(Level.WARNING, "Can't save the token.", ex);
        }
    }

    private static char[] readPassword(String user) {
        Console console = System.console();
        if (console != null) {
            System.out.format("Password for %s : ", Color.bold(Color.green(user)));
            return console.readPassword();
        }
        throw new RuntimeException("Can't read '" + user + "' password from the console.");
    }

    public static String binaryPrefix(long size) {
        long unit = 1000L;
        String suffix = "B";
        if (size < unit) {
            return String.format("%d %s", size, suffix);
        }
        int exp = (int)(Math.log(size) / Math.log(unit));
        String binPrefix = "KMGTPEZY".charAt(exp - 1) + suffix;
        return String.format("%.2f %s", (double)size / Math.pow(unit, exp), binPrefix);
    }
}

