/*
 * Decompiled with CFR 0.152.
 */
package com.oneops.secrets.utils;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Color {
    public static String esc(String msg, String escCode) {
        return "\u001b[" + escCode + "m" + msg + "\u001b[0m";
    }

    public static String color(String msg, int ... codes) {
        switch (codes.length) {
            case 0: {
                return msg;
            }
            case 1: {
                return Color.esc(msg, String.valueOf(codes[0]));
            }
        }
        List codeList = Arrays.stream(codes).mapToObj(Integer::toString).collect(Collectors.toList());
        String escCode = String.join((CharSequence)";", codeList);
        return Color.esc(msg, escCode);
    }

    public static String bold(String msg) {
        return Color.color(msg, 1);
    }

    public static String dim(String msg) {
        return Color.color(msg, 2);
    }

    public static String italic(String msg) {
        return Color.color(msg, 3);
    }

    public static String underline(String msg) {
        return Color.color(msg, 4);
    }

    public static String blink(String msg) {
        return Color.color(msg, 5);
    }

    public static String reversed(String msg) {
        return Color.color(msg, 5);
    }

    public static String strike(String msg) {
        return Color.color(msg, 9);
    }

    public static String black(String msg) {
        return Color.color(msg, 30);
    }

    public static String red(String msg) {
        return Color.color(msg, 31);
    }

    public static String green(String msg) {
        return Color.color(msg, 32);
    }

    public static String yellow(String msg) {
        return Color.color(msg, 33);
    }

    public static String blue(String msg) {
        return Color.color(msg, 34);
    }

    public static String magenta(String msg) {
        return Color.color(msg, 35);
    }

    public static String cyan(String msg) {
        return Color.color(msg, 36);
    }

    public static String gray(String msg) {
        return Color.color(msg, 37);
    }

    public static String sux(String msg) {
        return Color.cyan("\u2713 " + msg);
    }

    public static String err(String msg) {
        return Color.red("\u2717 " + msg);
    }

    public static String warn(String msg) {
        return Color.yellow("\u27a4 " + msg);
    }

    public static String highvolt(String msg) {
        return Color.yellow("\u26a1 " + msg);
    }

    public static String done(String msg) {
        return Color.green("\ud83c\udf7a " + msg);
    }

    public static String tick(String msg) {
        return "[\u2713] " + msg;
    }

    public static String dash(String msg) {
        return "[-] " + msg;
    }

    public static String dot(String msg) {
        return "\u25cf " + msg;
    }

    public static String circleDot(String msg) {
        return "\u25c9 " + msg;
    }
}

