/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet;

import com.onfleet.api.AdministratorApi;
import com.onfleet.api.ContainerApi;
import com.onfleet.api.DestinationApi;
import com.onfleet.api.HubApi;
import com.onfleet.api.OrganizationApi;
import com.onfleet.api.RecipientApi;
import com.onfleet.api.TaskApi;
import com.onfleet.api.TeamApi;
import com.onfleet.api.WebhookApi;
import com.onfleet.api.WorkerApi;
import java.util.Base64;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public class Onfleet {
    public static final String URL = "https://onfleet.com/api/v2";
    private OkHttpClient client;
    private final OrganizationApi organizationApi;
    private final AdministratorApi administratorApi;
    private final WorkerApi workerApi;
    private final HubApi hubApi;
    private final TeamApi teamApi;
    private final DestinationApi destinationApi;
    private final RecipientApi recipientApi;
    private final TaskApi taskApi;
    private final ContainerApi containerApi;
    private final WebhookApi webhookApi;

    public Onfleet(String apiKey) {
        this.initClient(apiKey);
        this.organizationApi = new OrganizationApi(this.client);
        this.administratorApi = new AdministratorApi(this.client);
        this.workerApi = new WorkerApi(this.client);
        this.hubApi = new HubApi(this.client);
        this.teamApi = new TeamApi(this.client);
        this.destinationApi = new DestinationApi(this.client);
        this.recipientApi = new RecipientApi(this.client);
        this.taskApi = new TaskApi(this.client);
        this.containerApi = new ContainerApi(this.client);
        this.webhookApi = new WebhookApi(this.client);
    }

    public OrganizationApi getOrganizationApi() {
        return this.organizationApi;
    }

    public AdministratorApi getAdministratorApi() {
        return this.administratorApi;
    }

    public WorkerApi getWorkerApi() {
        return this.workerApi;
    }

    public HubApi getHubApi() {
        return this.hubApi;
    }

    public TeamApi getTeamApi() {
        return this.teamApi;
    }

    public DestinationApi getDestinationApi() {
        return this.destinationApi;
    }

    public RecipientApi getRecipientApi() {
        return this.recipientApi;
    }

    public TaskApi getTaskApi() {
        return this.taskApi;
    }

    public ContainerApi getContainerApi() {
        return this.containerApi;
    }

    public WebhookApi getWebhookApi() {
        return this.webhookApi;
    }

    private void initClient(String apiKey) {
        String credentials = Base64.getEncoder().encodeToString(apiKey.getBytes());
        this.client = new OkHttpClient.Builder().addInterceptor(chain -> {
            Request originalRequest = chain.request();
            Request newRequest = originalRequest.newBuilder().header("Authorization", "Basic " + credentials).build();
            return chain.proceed(newRequest);
        }).build();
    }
}

