/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.Metadata;
import com.onfleet.models.administrator.AdminCreateParams;
import com.onfleet.models.administrator.AdminUpdateParams;
import com.onfleet.models.administrator.Administrator;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AdministratorApi
extends BaseApi {
    public AdministratorApi(OkHttpClient client) {
        super(client, "/admins");
    }

    public Administrator createAdministrator(AdminCreateParams createParams) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)createParams);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Administrator)this.handleResponse(response, (Type)((Object)Administrator.class));
    }

    public List<Administrator> listAdministrators() throws ApiException {
        Response response = this.sendRequest(HttpMethodType.GET, this.baseUrl);
        return (List)this.handleResponse(response, new TypeToken<List<Administrator>>(){}.getType());
    }

    public List<Administrator> queryWithMetadata(List<Metadata> metadata) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson(metadata);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (List)this.handleResponse(response, new TypeToken<List<Administrator>>(){}.getType());
    }

    public Administrator updateAdministrator(String adminId, AdminUpdateParams updateParams) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, adminId);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)updateParams);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.PUT, body, url);
        return (Administrator)this.handleResponse(response, (Type)((Object)Administrator.class));
    }

    public void deleteAdministrator(String adminId) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, adminId);
        this.sendRequest(HttpMethodType.DELETE, url);
    }
}

