/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.Metadata;
import com.onfleet.models.destination.Destination;
import com.onfleet.models.destination.DestinationCreateParams;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class DestinationApi
extends BaseApi {
    public DestinationApi(OkHttpClient client) {
        super(client, "/destinations");
    }

    public Destination getDestination(String id) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, id);
        Response response = this.sendRequest(HttpMethodType.GET, url);
        return (Destination)this.handleResponse(response, (Type)((Object)Destination.class));
    }

    public Destination createDestination(DestinationCreateParams destination) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)destination);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Destination)this.handleResponse(response, (Type)((Object)Destination.class));
    }

    public List<Destination> queryWithMetadata(List<Metadata> metadata) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson(metadata);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (List)this.handleResponse(response, new TypeToken<List<Destination>>(){}.getType());
    }
}

