/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.hub.Hub;
import com.onfleet.models.hub.HubParams;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HubApi
extends BaseApi {
    public HubApi(OkHttpClient client) {
        super(client, "/hubs");
    }

    public Hub createHub(HubParams hub) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)hub);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Hub)this.handleResponse(response, (Type)((Object)Hub.class));
    }

    public Hub updateHub(String hubId, HubParams hub) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, hubId);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)hub);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.PUT, body, url);
        return (Hub)this.handleResponse(response, (Type)((Object)Hub.class));
    }

    public List<Hub> listHubs() throws ApiException {
        Response response = this.sendRequest(HttpMethodType.GET, this.baseUrl);
        return (List)this.handleResponse(response, new TypeToken<ArrayList<Hub>>(){}.getType());
    }
}

