/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.Metadata;
import com.onfleet.models.recipient.Recipient;
import com.onfleet.models.recipient.RecipientCreateParams;
import com.onfleet.models.recipient.RecipientUpdateParams;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class RecipientApi
extends BaseApi {
    public RecipientApi(OkHttpClient client) {
        super(client, "/recipients");
    }

    public Recipient getSingleRecipient(String recipientId) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, recipientId);
        Response response = this.sendRequest(HttpMethodType.GET, url);
        return (Recipient)this.handleResponse(response, (Type)((Object)Recipient.class));
    }

    public Recipient findRecipientByName(String name) throws ApiException {
        String url = String.format("%s/name/%s", this.baseUrl, name);
        Response response = this.sendRequest(HttpMethodType.GET, url);
        return (Recipient)this.handleResponse(response, (Type)((Object)Recipient.class));
    }

    public Recipient findRecipientByPhone(String phone) throws ApiException {
        String url = String.format("%s/phone/%s", this.baseUrl, phone);
        Response response = this.sendRequest(HttpMethodType.GET, url);
        return (Recipient)this.handleResponse(response, (Type)((Object)Recipient.class));
    }

    public Recipient createRecipient(RecipientCreateParams createParams) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)createParams);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Recipient)this.handleResponse(response, (Type)((Object)Recipient.class));
    }

    public Recipient updateRecipient(String recipientId, RecipientUpdateParams updateParams) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, recipientId);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)updateParams);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.PUT, body, url);
        return (Recipient)this.handleResponse(response, (Type)((Object)Recipient.class));
    }

    public List<Recipient> queryWithMetadata(List<Metadata> metadata) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson(metadata);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (List)this.handleResponse(response, new TypeToken<List<Recipient>>(){}.getType());
    }
}

