/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.Metadata;
import com.onfleet.models.task.AutomaticallyAssignTaskResult;
import com.onfleet.models.task.BatchJobStatus;
import com.onfleet.models.task.Task;
import com.onfleet.models.task.TaskAutoAssignMultiParams;
import com.onfleet.models.task.TaskBatchCreateResponseAsync;
import com.onfleet.models.task.TaskCloneOptions;
import com.onfleet.models.task.TaskCloneParams;
import com.onfleet.models.task.TaskForceCompletion;
import com.onfleet.models.task.TaskForceCompletionParams;
import com.onfleet.models.task.TaskListQueryParams;
import com.onfleet.models.task.TaskParams;
import com.onfleet.models.task.TaskParamsList;
import com.onfleet.models.task.TaskState;
import com.onfleet.models.task.Tasks;
import com.onfleet.models.task.TasksPaginated;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TaskApi
extends BaseApi {
    public TaskApi(OkHttpClient client) {
        super(client, "/tasks");
    }

    public Task createTask(TaskParams taskParams) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)taskParams);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Task)this.handleResponse(response, (Type)((Object)Task.class));
    }

    public Tasks createTasksBatch(List<TaskParams> tasks) throws ApiException {
        TaskParamsList taskList = new TaskParamsList(tasks);
        String url = String.format("%s/batch", this.baseUrl);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)taskList);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, url);
        return (Tasks)this.handleResponse(response, (Type)((Object)Tasks.class));
    }

    public TaskBatchCreateResponseAsync createTasksBatchAsync(List<TaskParams> tasks) throws ApiException {
        TaskParamsList taskList = new TaskParamsList(tasks);
        String url = String.format("%s/batch-async", this.baseUrl);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)taskList);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, url);
        return (TaskBatchCreateResponseAsync)this.handleResponse(response, (Type)((Object)TaskBatchCreateResponseAsync.class));
    }

    public BatchJobStatus getBatchJobStatus(String jobId) throws ApiException {
        String url = String.format("%s/batch/%s", this.baseUrl, jobId);
        Response response = this.sendRequest(HttpMethodType.GET, url);
        return (BatchJobStatus)this.handleResponse(response, (Type)((Object)BatchJobStatus.class));
    }

    public AutomaticallyAssignTaskResult autoAssign(TaskAutoAssignMultiParams params) throws ApiException {
        String url = String.format("%s/autoAssign", this.baseUrl);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)params);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, url);
        return (AutomaticallyAssignTaskResult)this.handleResponse(response, (Type)((Object)AutomaticallyAssignTaskResult.class));
    }

    public TasksPaginated listTasks(TaskListQueryParams queryParams) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, "all");
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        if (queryParams.getFrom() <= 0L) {
            throw new IllegalArgumentException("'from' parameter is required");
        }
        urlBuilder.addQueryParameter("from", String.valueOf(queryParams.getFrom()));
        if (queryParams.getTo() != null) {
            urlBuilder.addQueryParameter("to", String.valueOf(queryParams.getTo()));
        }
        if (queryParams.getLastId() != null) {
            urlBuilder.addQueryParameter("lastId", queryParams.getLastId());
        }
        if (queryParams.getStates() != null) {
            urlBuilder.addQueryParameter("state", queryParams.getStates().stream().map(TaskState::getValue).map(Object::toString).collect(Collectors.joining(",")));
        }
        if (queryParams.getWorker() != null) {
            urlBuilder.addQueryParameter("worker", queryParams.getWorker());
        }
        if (queryParams.getCompleteBeforeBefore() != null) {
            urlBuilder.addQueryParameter("completeBeforeBefore", String.valueOf(queryParams.getCompleteBeforeBefore()));
        }
        if (queryParams.getCompleteAfterAfter() != null) {
            urlBuilder.addQueryParameter("completeAfterAfter", String.valueOf(queryParams.getCompleteAfterAfter()));
        }
        if (queryParams.getTaskDependencies() != null) {
            urlBuilder.addQueryParameter("dependencies", String.join((CharSequence)",", queryParams.getTaskDependencies()));
        }
        return (TasksPaginated)this.handleResponse(this.sendRequest(HttpMethodType.GET, urlBuilder.build().toString()), (Type)((Object)TasksPaginated.class));
    }

    public List<Task> queryWithMetadata(List<Metadata> metadata) throws ApiException {
        String url = String.format("%s/metadata", this.baseUrl);
        String jsonPayload = GsonSingleton.getInstance().toJson(metadata);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, url);
        return (List)this.handleResponse(response, new TypeToken<List<Task>>(){}.getType());
    }

    public Task getSingleTask(String taskId) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, taskId);
        Response response = this.sendRequest(HttpMethodType.POST, url);
        return (Task)this.handleResponse(response, (Type)((Object)Task.class));
    }

    public Task getTaskByShortId(String taskShortId) throws ApiException {
        String url = String.format("%s/shortId/%s", this.baseUrl, taskShortId);
        Response response = this.sendRequest(HttpMethodType.POST, url);
        return (Task)this.handleResponse(response, (Type)((Object)Task.class));
    }

    public Task updateTask(String taskId, TaskParams task) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, taskId);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)task);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, url);
        return (Task)this.handleResponse(response, (Type)((Object)Task.class));
    }

    public void completeTask(String taskId, TaskForceCompletionParams completionDetails) throws ApiException {
        TaskForceCompletion details = new TaskForceCompletion(completionDetails);
        String url = String.format("%s/%s/complete", this.baseUrl, taskId);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)details);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        this.sendRequest(HttpMethodType.POST, body, url);
    }

    public Task cloneTask(String taskId, TaskCloneParams cloneParams) throws ApiException {
        String url = String.format("%s/%s/clone", this.baseUrl, taskId);
        if (cloneParams != null) {
            TaskCloneOptions options = new TaskCloneOptions(cloneParams);
            String jsonPayload = GsonSingleton.getInstance().toJson((Object)options);
            RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
            Response response = this.sendRequest(HttpMethodType.POST, body, url);
            return (Task)this.handleResponse(response, (Type)((Object)Task.class));
        }
        Response response = this.sendRequest(HttpMethodType.POST, url);
        return (Task)this.handleResponse(response, (Type)((Object)Task.class));
    }

    public Task cloneTask(String taskId) throws ApiException {
        return this.cloneTask(taskId, null);
    }

    public void deleteTask(String taskId) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, taskId);
        this.sendRequest(HttpMethodType.DELETE, url);
    }
}

