/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.VehicleType;
import com.onfleet.models.team.Team;
import com.onfleet.models.team.TeamCreateParams;
import com.onfleet.models.team.TeamDriverEtaQueryParams;
import com.onfleet.models.team.TeamTasks;
import com.onfleet.models.team.TeamTasksQueryParams;
import com.onfleet.models.team.TeamUpdateParams;
import com.onfleet.models.team.WorkerRoute;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TeamApi
extends BaseApi {
    public TeamApi(OkHttpClient client) {
        super(client, "/teams");
    }

    public Team getTeam(String teamId) throws ApiException {
        return (Team)this.handleResponse(this.sendRequest(HttpMethodType.GET, String.format("%s/%s", this.baseUrl, teamId)), (Type)((Object)Team.class));
    }

    public List<Team> listTeams() throws ApiException {
        return (List)this.handleResponse(this.sendRequest(HttpMethodType.GET, this.baseUrl), new TypeToken<List<Team>>(){}.getType());
    }

    public Team createTeam(TeamCreateParams team) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)team);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Team)this.handleResponse(response, (Type)((Object)Team.class));
    }

    public Team updateTeam(String teamId, TeamUpdateParams params) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, teamId);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)params);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.PUT, body, url);
        return (Team)this.handleResponse(response, (Type)((Object)Team.class));
    }

    public void deleteTeam(String teamId) throws ApiException {
        this.sendRequest(HttpMethodType.DELETE, String.format("%s/%s", this.baseUrl, teamId));
    }

    public WorkerRoute getDriverTimeEstimate(String teamId, TeamDriverEtaQueryParams params) throws ApiException {
        if ((params.getDropoffLocation() == null || params.getDropoffLocation().isEmpty()) && (params.getPickupLocation() == null || params.getPickupLocation().isEmpty())) {
            throw new IllegalArgumentException("Request must have at least one of dropoffLocation or pickupLocation.");
        }
        String url = String.format("%s/%s/estimate", this.baseUrl, teamId);
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (params.getDropoffLocation() != null && !params.getDropoffLocation().isEmpty()) {
            urlBuilder.addQueryParameter("dropoffLocation", params.getDropoffLocation());
        }
        if (params.getPickupLocation() != null && !params.getPickupLocation().isEmpty()) {
            urlBuilder.addQueryParameter("pickupLocation", params.getPickupLocation());
        }
        if (params.getPickupTime() != null) {
            urlBuilder.addQueryParameter("pickupTime", params.getPickupTime().toString());
        }
        if (params.getRestrictedVehicleTypes() != null && !params.getRestrictedVehicleTypes().isEmpty()) {
            String restrictedTypesString = params.getRestrictedVehicleTypes().stream().map(VehicleType::getValue).collect(Collectors.joining(","));
            urlBuilder.addQueryParameter("restrictedVehiclesTypes", restrictedTypesString);
        }
        if (params.getServiceTime() != null) {
            urlBuilder.addQueryParameter("serviceTime", params.getServiceTime().toString());
        }
        Response response = this.sendRequest(HttpMethodType.GET, urlBuilder.build().toString());
        return (WorkerRoute)this.handleResponse(response, (Type)((Object)WorkerRoute.class));
    }

    public TeamTasks getUnassignedTasks(String teamId, TeamTasksQueryParams params) throws ApiException {
        String url = String.format("%s/%s/tasks", this.baseUrl, teamId);
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (params.getIsPickupTask() != null) {
            urlBuilder.addQueryParameter("isPickupTask", params.getIsPickupTask().toString());
        }
        if (params.getFrom() != null) {
            urlBuilder.addQueryParameter("from", params.getFrom().toString());
        }
        if (params.getTo() != null) {
            urlBuilder.addQueryParameter("to", params.getTo().toString());
        }
        if (params.getLastId() != null && !params.getLastId().isEmpty()) {
            urlBuilder.addQueryParameter("lastId", params.getLastId());
        }
        return (TeamTasks)this.handleResponse(this.sendRequest(HttpMethodType.GET, urlBuilder.build().toString()), (Type)((Object)TeamTasks.class));
    }
}

