/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.webhook.Webhook;
import com.onfleet.models.webhook.WebhookCreateParams;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WebhookApi
extends BaseApi {
    public WebhookApi(OkHttpClient client) {
        super(client, "/webhooks");
    }

    public Webhook create(WebhookCreateParams params) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)params);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Webhook)this.handleResponse(response, (Type)((Object)Webhook.class));
    }

    public List<Webhook> list() throws ApiException {
        Response response = this.sendRequest(HttpMethodType.GET, this.baseUrl);
        return (List)this.handleResponse(response, new TypeToken<List<Webhook>>(){}.getType());
    }

    public void delete(String webhookId) throws ApiException {
        this.sendRequest(HttpMethodType.DELETE, String.format("%s/%s", this.baseUrl, webhookId));
    }
}

