/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.onfleet.api.BaseApi;
import com.onfleet.exceptions.ApiException;
import com.onfleet.models.Metadata;
import com.onfleet.models.worker.Worker;
import com.onfleet.models.worker.WorkerCreateParams;
import com.onfleet.models.worker.WorkerFilterFields;
import com.onfleet.models.worker.WorkerListQueryParams;
import com.onfleet.models.worker.WorkerQueryParams;
import com.onfleet.models.worker.WorkerScheduleEntries;
import com.onfleet.models.worker.WorkerScheduleEntry;
import com.onfleet.models.worker.WorkerStates;
import com.onfleet.models.worker.WorkerTasks;
import com.onfleet.models.worker.WorkerTasksQueryParams;
import com.onfleet.models.worker.WorkerUpdateParams;
import com.onfleet.models.worker.Workers;
import com.onfleet.utils.GsonSingleton;
import com.onfleet.utils.HttpMethodType;
import com.onfleet.utils.MediaTypes;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WorkerApi
extends BaseApi {
    public WorkerApi(OkHttpClient client) {
        super(client, "/workers");
    }

    public Worker createWorker(WorkerCreateParams worker) throws ApiException {
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)worker);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, this.baseUrl);
        return (Worker)this.handleResponse(response, (Type)((Object)Worker.class));
    }

    public List<Worker> listWorkers(WorkerListQueryParams params) throws ApiException {
        if (params == null) {
            return (List)this.handleResponse(this.sendRequest(HttpMethodType.GET, this.baseUrl), new TypeToken<List<Worker>>(){}.getType());
        }
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.baseUrl).newBuilder();
        if (params.getFields() != null && !params.getFields().isEmpty()) {
            urlBuilder.addQueryParameter("fields", params.getFields().stream().map(WorkerFilterFields::getValue).collect(Collectors.joining(",")));
        }
        if (params.getTeamIds() != null && !params.getTeamIds().isEmpty()) {
            urlBuilder.addQueryParameter("teamsIds", String.join((CharSequence)",", params.getTeamIds()));
        }
        if (params.getWorkerStates() != null && !params.getWorkerStates().isEmpty()) {
            urlBuilder.addQueryParameter("states", params.getWorkerStates().stream().map(WorkerStates::getValue).map(Object::toString).collect(Collectors.joining(",")));
        }
        if (params.getPhoneNumbers() != null && !params.getPhoneNumbers().isEmpty()) {
            urlBuilder.addQueryParameter("phoneNumbers", String.join((CharSequence)",", params.getPhoneNumbers()));
        }
        if (Boolean.TRUE.equals(params.getIncludePasswordDetails())) {
            urlBuilder.addQueryParameter("includePasswordDetails", "true");
        }
        Response response = this.sendRequest(HttpMethodType.GET, urlBuilder.toString());
        return (List)this.handleResponse(response, new TypeToken<List<Worker>>(){}.getType());
    }

    public List<Worker> listWorkers() throws ApiException {
        return this.listWorkers(null);
    }

    public WorkerTasks getWorkersTasks(String workerId, WorkerTasksQueryParams params) throws ApiException {
        String url = String.format("%s/%s/tasks", this.baseUrl, workerId);
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (params.getFrom() != null) {
            urlBuilder.addQueryParameter("from", params.getFrom().toString());
        }
        if (params.getTo() != null) {
            urlBuilder.addQueryParameter("to", params.getTo().toString());
        }
        if (params.getLastId() != null) {
            urlBuilder.addQueryParameter("lastId", params.getLastId());
        }
        if (params.getPickUpTask() != null) {
            urlBuilder.addQueryParameter("isPickUpTask", params.getPickUpTask().toString());
        }
        Response response = this.sendRequest(HttpMethodType.GET, urlBuilder.build().toString());
        return (WorkerTasks)this.handleResponse(response, (Type)((Object)WorkerTasks.class));
    }

    public WorkerTasks getWorkersTasks(String workerId) throws ApiException {
        return this.getWorkersTasks(workerId, new WorkerTasksQueryParams.Builder().build());
    }

    public Workers getWorkersByLocation(Double longitude, Double latitude, Integer radius) throws ApiException {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)(this.baseUrl + "/location")).newBuilder();
        urlBuilder.addQueryParameter("longitude", longitude.toString());
        urlBuilder.addQueryParameter("latitude", latitude.toString());
        if (radius != null) {
            urlBuilder.addQueryParameter("radius", radius.toString());
        }
        Response response = this.sendRequest(HttpMethodType.GET, urlBuilder.build().toString());
        return (Workers)this.handleResponse(response, (Type)((Object)Workers.class));
    }

    public Worker getSingleWorker(String workerId, WorkerQueryParams params) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, workerId);
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (params.getFilterFields() != null && !params.getFilterFields().isEmpty()) {
            String filterQuery = params.getFilterFields().stream().map(WorkerFilterFields::getValue).collect(Collectors.joining(","));
            urlBuilder.addQueryParameter("filter", filterQuery);
        }
        if (params.getPhones() != null && !params.getPhones().isEmpty()) {
            urlBuilder.addQueryParameter("phones", String.join((CharSequence)",", params.getPhones()));
        }
        if (params.getStates() != null) {
            urlBuilder.addQueryParameter("states", params.getStates().stream().map(Object::toString).collect(Collectors.joining(",")));
        }
        if (params.getTeams() != null) {
            urlBuilder.addQueryParameter("teams", String.join((CharSequence)",", params.getTeams()));
        }
        if (params.getEnableAnalytics() != null) {
            urlBuilder.addQueryParameter("analytics", params.getEnableAnalytics().toString());
        }
        Response response = this.sendRequest(HttpMethodType.GET, urlBuilder.build().toString());
        return (Worker)this.handleResponse(response, (Type)((Object)Worker.class));
    }

    public List<Worker> queryWithMetadata(List<Metadata> metadata) throws ApiException {
        String url = String.format("%s/metadata", this.baseUrl);
        String jsonPayload = GsonSingleton.getInstance().toJson(metadata);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.PUT, body, url);
        return (List)this.handleResponse(response, new TypeToken<List<Worker>>(){}.getType());
    }

    public Worker updateWorker(String workerId, WorkerUpdateParams params) throws ApiException {
        String url = String.format("%s/%s", this.baseUrl, workerId);
        String jsonPayload = GsonSingleton.getInstance().toJson((Object)params);
        RequestBody body = RequestBody.create((String)jsonPayload, (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.PUT, body, url);
        return (Worker)this.handleResponse(response, (Type)((Object)Worker.class));
    }

    public void deleteWorker(String workerId) throws ApiException {
        this.sendRequest(HttpMethodType.DELETE, String.format("%s/%s", this.baseUrl, workerId));
    }

    public WorkerScheduleEntries getWorkerSchedule(String workerId) throws ApiException {
        Response response = this.sendRequest(HttpMethodType.GET, String.format("%s/%s/schedule", this.baseUrl, workerId));
        return (WorkerScheduleEntries)this.handleResponse(response, (Type)((Object)WorkerScheduleEntries.class));
    }

    public WorkerScheduleEntries setWorkerSchedule(String workerId, List<WorkerScheduleEntry> entries) throws ApiException {
        String url = String.format("%s/%s/schedule", this.baseUrl, workerId);
        JsonObject jsonPayload = new JsonObject();
        JsonArray entriesArray = new JsonArray();
        for (WorkerScheduleEntry entry : entries) {
            JsonObject entryObject = new JsonObject();
            entryObject.addProperty("date", entry.getDate());
            entryObject.addProperty("timezone", entry.getTimezone());
            JsonArray shiftsArray = new JsonArray();
            for (List<Long> shift : entry.getShifts()) {
                JsonArray shiftArray = new JsonArray();
                shiftArray.add((Number)shift.get(0));
                shiftArray.add((Number)shift.get(1));
                shiftsArray.add((JsonElement)shiftArray);
            }
            entryObject.add("shifts", (JsonElement)shiftsArray);
            entriesArray.add((JsonElement)entryObject);
        }
        jsonPayload.add("entries", (JsonElement)entriesArray);
        RequestBody body = RequestBody.create((String)jsonPayload.toString(), (MediaType)MediaTypes.JSON);
        Response response = this.sendRequest(HttpMethodType.POST, body, url);
        return (WorkerScheduleEntries)this.handleResponse(response, (Type)((Object)WorkerScheduleEntries.class));
    }
}

