/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.exceptions;

import com.onfleet.models.ErrorResponse;
import com.onfleet.utils.GsonSingleton;
import java.io.IOException;
import okhttp3.Response;

public class ApiException
extends Exception {
    private int statusCode;
    private ErrorResponse errorResponse;

    public ApiException(String message, Throwable cause) {
        super(message, cause);
    }

    public ApiException(Response response) {
        super(response.message());
        this.statusCode = response.code();
        try {
            if (response.body() != null) {
                this.errorResponse = (ErrorResponse)GsonSingleton.getInstance().fromJson(response.body().string(), ErrorResponse.class);
            }
        }
        catch (IOException e) {
            this.initCause(e);
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public ErrorResponse getErrorResponse() {
        return this.errorResponse;
    }
}

