/*
 * Decompiled with CFR 0.152.
 */
package com.onfleet.models.task;

import com.onfleet.models.task.TaskState;
import java.util.List;

public class TaskListQueryParams {
    private long from;
    private Long to;
    private String lastId;
    private String worker;
    private Long completeBeforeBefore;
    private Long completeAfterAfter;
    private List<TaskState> states;
    private List<String> taskDependencies;

    public TaskListQueryParams(long from) {
        this.from = from;
    }

    private TaskListQueryParams(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.lastId = builder.lastId;
        this.worker = builder.worker;
        this.completeBeforeBefore = builder.completeBeforeBefore;
        this.completeAfterAfter = builder.completeAfterAfter;
        this.states = builder.states;
        this.taskDependencies = builder.taskDependencies;
    }

    public long getFrom() {
        return this.from;
    }

    public Long getTo() {
        return this.to;
    }

    public String getLastId() {
        return this.lastId;
    }

    public String getWorker() {
        return this.worker;
    }

    public Long getCompleteBeforeBefore() {
        return this.completeBeforeBefore;
    }

    public Long getCompleteAfterAfter() {
        return this.completeAfterAfter;
    }

    public List<TaskState> getStates() {
        return this.states;
    }

    public List<String> getTaskDependencies() {
        return this.taskDependencies;
    }

    public static class Builder {
        private final long from;
        private Long to;
        private String lastId;
        private String worker;
        private Long completeBeforeBefore;
        private Long completeAfterAfter;
        private List<TaskState> states;
        private List<String> taskDependencies;

        public Builder(long from) {
            this.from = from;
        }

        public Builder setTo(Long to) {
            this.to = to;
            return this;
        }

        public Builder setLastId(String lastId) {
            this.lastId = lastId;
            return this;
        }

        public Builder setWorker(String worker) {
            this.worker = worker;
            return this;
        }

        public Builder setCompleteBeforeBefore(Long completeBeforeBefore) {
            this.completeBeforeBefore = completeBeforeBefore;
            return this;
        }

        public Builder setCompleteAfterAfter(Long completeAfterAfter) {
            this.completeAfterAfter = completeAfterAfter;
            return this;
        }

        public Builder setStates(List<TaskState> states) {
            this.states = states;
            return this;
        }

        public Builder setTaskDependencies(List<String> taskDependencies) {
            this.taskDependencies = taskDependencies;
            return this;
        }

        public TaskListQueryParams build() {
            return new TaskListQueryParams(this);
        }
    }
}

