/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IApplication;
import com.openshift.client.IApplicationGear;
import com.openshift.client.IApplicationGearComponent;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.response.GearResourceDTO;
import java.util.Collections;
import java.util.List;

public class ApplicationGearResource
extends AbstractOpenShiftResource
implements IApplicationGear {
    private final String uuid;
    private final String gitUrl;
    private final List<IApplicationGearComponent> components;
    private final ApplicationResource applicationResource;

    protected ApplicationGearResource(String uuid, String gitUrl, List<IApplicationGearComponent> components, ApplicationResource applicationResource) {
        super(applicationResource.getService());
        this.uuid = uuid;
        this.gitUrl = gitUrl;
        this.components = components;
        this.applicationResource = applicationResource;
    }

    protected ApplicationGearResource(GearResourceDTO gearDTO, List<IApplicationGearComponent> components, ApplicationResource applicationResource) {
        this(gearDTO.getUuid(), gearDTO.getGitUrl(), components, applicationResource);
    }

    @Override
    public final String getUuid() {
        return this.uuid;
    }

    @Override
    public final String getGitUrl() {
        return this.gitUrl;
    }

    @Override
    public final List<IApplicationGearComponent> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public final IApplication getApplication() {
        return this.applicationResource;
    }

    @Override
    public void refresh() throws OpenShiftException {
    }
}

