/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.utils;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;

public class UrlBuilder {
    private static final String URL_ENCODING = "UTF-8";
    private static final String HOST_PROTOCOL_DELIMITER = ":";
    private static final String HTTP_PROTOCOL_PREFIX = "http://";
    private static final char PARAMETER_URL_DELIMITER = '?';
    private static final char PARAMETER_DELIMITER = '&';
    private static final char PARAMETER_NAME_VALUE_DELIMITER = '=';
    private static final char PATH_SEPARATOR = '/';
    private StringBuilder urlStringBuilder = new StringBuilder();
    private boolean parametersAdded = false;

    public UrlBuilder() {
    }

    public UrlBuilder(String baseUrl) {
        this.urlStringBuilder.append(baseUrl);
    }

    public UrlBuilder(URL baseUrl) {
        this.urlStringBuilder.append(baseUrl.toString());
    }

    public UrlBuilder host(String host) {
        this.urlStringBuilder.append(HTTP_PROTOCOL_PREFIX);
        this.urlStringBuilder.append(host);
        return this;
    }

    public UrlBuilder port(String port) {
        this.urlStringBuilder.append(HOST_PROTOCOL_DELIMITER);
        this.urlStringBuilder.append(port);
        return this;
    }

    public UrlBuilder path(String path) {
        this.urlStringBuilder.append('/');
        this.urlStringBuilder.append(path);
        return this;
    }

    public UrlBuilder path(Collection<String> paths) {
        for (String path : paths) {
            this.path(path);
        }
        return this;
    }

    public UrlBuilder parameter(String name, String value) {
        if (value != null) {
            this.appendParameterDelimiter();
            this.urlStringBuilder.append(name).append('=').append(this.urlEncode(value));
        }
        return this;
    }

    private void appendParameterDelimiter() {
        if (!this.parametersAdded) {
            this.urlStringBuilder.append('?');
            this.parametersAdded = true;
        } else {
            this.urlStringBuilder.append('&');
        }
    }

    public UrlBuilder parameters(String ... parameters) {
        for (String parameter : parameters) {
            this.parameter(parameter);
        }
        return this;
    }

    public UrlBuilder parameter(String parameter) {
        this.appendParameterDelimiter();
        this.urlStringBuilder.append(this.urlEncode(parameter));
        return this;
    }

    private String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public URL toUrl() throws MalformedURLException {
        return new URL(this.urlStringBuilder.toString());
    }

    public String toString() {
        return this.urlStringBuilder.toString();
    }
}

