/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.client.cartridge.query;

import com.openshift.client.cartridge.ICartridge;
import com.openshift.client.cartridge.query.AbstractCartridgeQuery;
import java.util.regex.Pattern;

public class CartridgeNameRegexQuery
extends AbstractCartridgeQuery {
    private Pattern namePattern;

    public CartridgeNameRegexQuery(String namePattern) {
        this(Pattern.compile(namePattern));
    }

    public CartridgeNameRegexQuery(Pattern namePattern) {
        this.namePattern = namePattern;
    }

    @Override
    public <C extends ICartridge> boolean matches(C cartridge) {
        if (cartridge == null) {
            return false;
        }
        return this.namePattern.matcher(cartridge.getName()).find();
    }

    public String toString() {
        return "CartridgeNameRegexQuery [namePattern=" + this.namePattern + "]";
    }
}

