/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.httpclient;

import com.openshift.client.IHttpClient;
import com.openshift.internal.client.httpclient.UrlConnectionHttpClient;

public class UrlConnectionHttpClientBuilder {
    private String userAgent;
    private String username;
    private String password;
    private String authKey;
    private String authIV;
    private String acceptedMediaType;
    private String version;
    private Integer configTimeout;
    private IHttpClient.ISSLCertificateCallback callback;
    private String excludeSSLCipherRegex;

    public UrlConnectionHttpClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public UrlConnectionHttpClientBuilder setCredentials(String username, String password) {
        return this.setCredentials(username, password, null, null);
    }

    public UrlConnectionHttpClientBuilder setCredentials(String username, String password, String authKey, String authIV) {
        this.username = username;
        this.password = password;
        this.authKey = authKey;
        this.authIV = authIV;
        return this;
    }

    public UrlConnectionHttpClientBuilder setConfigTimeout(Integer configTimeout) {
        this.configTimeout = configTimeout;
        return this;
    }

    public UrlConnectionHttpClientBuilder setAcceptMediaType(String mediaType) {
        this.acceptedMediaType = mediaType;
        return this;
    }

    public UrlConnectionHttpClientBuilder setSSLCertificateCallback(IHttpClient.ISSLCertificateCallback callback) {
        this.callback = callback;
        return this;
    }

    public UrlConnectionHttpClientBuilder setVersion(String version) {
        this.version = version;
        return this;
    }

    public UrlConnectionHttpClientBuilder excludeSSLCipher(String excludeSSLCipherRegex) {
        this.excludeSSLCipherRegex = excludeSSLCipherRegex;
        return this;
    }

    public IHttpClient client() {
        return new UrlConnectionHttpClient(this.username, this.password, this.userAgent, this.acceptedMediaType, this.version, this.authKey, this.authIV, this.callback, this.configTimeout, this.excludeSSLCipherRegex);
    }
}

