/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient;

import com.openshift.internal.restclient.DefaultClient;
import com.openshift.internal.restclient.ResourceFactory;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ISSLCertificateCallback;
import com.openshift.restclient.NoopSSLCertificateCallback;
import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.IAuthorizationStrategy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;

public class ClientBuilder {
    private String baseUrl;
    private ISSLCertificateCallback sslCertificateCallback;
    private X509Certificate certificate;
    private String certificateAlias;
    private IResourceFactory resourceFactory;
    private IAuthorizationStrategy authStrategy;
    private String withUserName;
    private Object token;

    public ClientBuilder() {
        this(null);
    }

    public ClientBuilder(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ClientBuilder sslCertificateCallback(ISSLCertificateCallback callback) {
        this.sslCertificateCallback = callback;
        return this;
    }

    public ClientBuilder sslCertificate(String alias, X509Certificate cert) {
        this.certificateAlias = alias;
        this.certificate = cert;
        return this;
    }

    public ClientBuilder resourceFactory(IResourceFactory factory) {
        this.resourceFactory = factory;
        return this;
    }

    @Deprecated
    public ClientBuilder resourceFactory(IAuthorizationStrategy authStrategy) {
        this.authStrategy = authStrategy;
        return this;
    }

    public ClientBuilder authorizationStrategy(IAuthorizationStrategy authStrategy) {
        this.authStrategy = authStrategy;
        return this;
    }

    public ClientBuilder toCluster(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public ClientBuilder withUserName(String userName) {
        this.withUserName = userName;
        return this;
    }

    public ClientBuilder usingToken(String userName) {
        this.token = this.token;
        return this;
    }

    public IClient build() {
        try {
            ISSLCertificateCallback sslCallback = this.defaultIfNull(this.sslCertificateCallback, new NoopSSLCertificateCallback());
            IResourceFactory factory = this.defaultIfNull(this.resourceFactory, new ResourceFactory(null));
            DefaultClient client = new DefaultClient(new URL(this.baseUrl), null, sslCallback, factory, this.certificateAlias, this.certificate);
            client.setAuthorizationStrategy(this.authStrategy);
            return client;
        }
        catch (MalformedURLException e) {
            throw new OpenShiftException((Throwable)e, "", new Object[0]);
        }
    }

    private <T> T defaultIfNull(T value, T aDefault) {
        if (value != null) {
            return value;
        }
        return aDefault;
    }
}

