/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.restclient.authorization;

import com.openshift.restclient.OpenShiftException;
import com.openshift.restclient.authorization.IAuthorizationDetails;
import com.openshift.restclient.model.IStatus;
import org.apache.commons.lang.StringUtils;

public class UnauthorizedException
extends OpenShiftException {
    private static final long serialVersionUID = -3999801367045252906L;
    private static final String MSG_BASE = "Unauthorized to access resource.";
    private IAuthorizationDetails details;
    private IStatus status;

    public UnauthorizedException(IAuthorizationDetails details) {
        this(details, null);
    }

    public UnauthorizedException(IAuthorizationDetails details, IStatus status) {
        super(String.format("%s See the authorization details for additional information or contact your system administrator.", MSG_BASE), new Object[0]);
        this.details = details;
        this.status = status;
    }

    public IAuthorizationDetails getAuthorizationDetails() {
        return this.details;
    }

    @Override
    public String getMessage() {
        String scheme = this.details.getScheme();
        if (StringUtils.isNotBlank((String)scheme)) {
            return String.format("%s You can access the server using %s authentication.", MSG_BASE, scheme);
        }
        return StringUtils.defaultIfEmpty((String)this.details.getMessage(), (String)super.getMessage());
    }

    @Override
    public IStatus getStatus() {
        return this.status;
    }
}

