/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient;

import com.openshift.internal.restclient.model.Build;
import com.openshift.internal.restclient.model.BuildConfig;
import com.openshift.internal.restclient.model.ConfigMap;
import com.openshift.internal.restclient.model.DeploymentConfig;
import com.openshift.internal.restclient.model.ImageStream;
import com.openshift.internal.restclient.model.KubernetesEvent;
import com.openshift.internal.restclient.model.KubernetesResource;
import com.openshift.internal.restclient.model.LimitRange;
import com.openshift.internal.restclient.model.List;
import com.openshift.internal.restclient.model.Pod;
import com.openshift.internal.restclient.model.Project;
import com.openshift.internal.restclient.model.ReplicationController;
import com.openshift.internal.restclient.model.ResourceQuota;
import com.openshift.internal.restclient.model.Route;
import com.openshift.internal.restclient.model.Secret;
import com.openshift.internal.restclient.model.Service;
import com.openshift.internal.restclient.model.ServiceAccount;
import com.openshift.internal.restclient.model.Status;
import com.openshift.internal.restclient.model.authorization.OpenshiftPolicy;
import com.openshift.internal.restclient.model.authorization.OpenshiftRole;
import com.openshift.internal.restclient.model.authorization.PolicyBinding;
import com.openshift.internal.restclient.model.authorization.RoleBinding;
import com.openshift.internal.restclient.model.build.BuildRequest;
import com.openshift.internal.restclient.model.image.ImageStreamImport;
import com.openshift.internal.restclient.model.oauth.OAuthAccessToken;
import com.openshift.internal.restclient.model.oauth.OAuthAuthorizeToken;
import com.openshift.internal.restclient.model.oauth.OAuthClient;
import com.openshift.internal.restclient.model.oauth.OAuthClientAuthorization;
import com.openshift.internal.restclient.model.project.OpenshiftProjectRequest;
import com.openshift.internal.restclient.model.properties.ResourcePropertiesRegistry;
import com.openshift.internal.restclient.model.template.Template;
import com.openshift.internal.restclient.model.user.OpenShiftUser;
import com.openshift.internal.restclient.model.volume.PersistentVolume;
import com.openshift.internal.restclient.model.volume.PersistentVolumeClaim;
import com.openshift.restclient.IApiTypeMapper;
import com.openshift.restclient.IClient;
import com.openshift.restclient.IResourceFactory;
import com.openshift.restclient.ResourceFactoryException;
import com.openshift.restclient.UnsupportedVersionException;
import com.openshift.restclient.model.IResource;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.dmr.ModelNode;

public class ResourceFactory
implements IResourceFactory {
    private static final String KIND = "kind";
    private static final String APIVERSION = "apiVersion";
    private static final Map<String, Class<? extends IResource>> IMPL_MAP = new HashMap<String, Class<? extends IResource>>();
    private IClient client;

    public ResourceFactory(IClient client) {
        this.client = client;
    }

    public static Map<String, Class<? extends IResource>> getImplMap() {
        return Collections.unmodifiableMap(IMPL_MAP);
    }

    @Override
    public java.util.List<IResource> createList(String json, String kind) {
        ModelNode data = ModelNode.fromJSONString((String)json);
        String dataKind = data.get(KIND).asString();
        if (!(kind.toString() + "List").equals(dataKind)) {
            throw new RuntimeException(String.format("Unexpected container type '%s' for desired kind: %s", dataKind, kind));
        }
        try {
            String version = data.get(APIVERSION).asString();
            return this.buildList(version, data.get("items").asList(), kind);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private java.util.List<IResource> buildList(String version, java.util.List<ModelNode> items, String kind) throws NoSuchMethodException, SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<IResource> resources = new ArrayList<IResource>(items.size());
        for (ModelNode item : items) {
            resources.add(this.create(item, version, kind));
        }
        return resources;
    }

    public IResource create(InputStream input) {
        try {
            String resource = IOUtils.toString((InputStream)input, (String)"UTF-8");
            return this.create(resource);
        }
        catch (IOException e) {
            throw new ResourceFactoryException((Throwable)e, "There was an exception creating the resource from the InputStream", new Object[0]);
        }
    }

    @Override
    public Object createInstanceFrom(String response) {
        return this.create(response);
    }

    @Override
    public <T extends IResource> T create(String response) {
        try {
            ModelNode node = ModelNode.fromJSONString((String)response);
            String version = node.get(APIVERSION).asString();
            String kind = node.get(KIND).asString();
            return (T)this.create(node, version, kind);
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceFactoryException((Throwable)e, "There was an exception creating the resource from: %s", response);
        }
    }

    @Override
    public <T extends IResource> T create(String version, String kind) {
        return (T)this.create(new ModelNode(), version, kind);
    }

    @Override
    public <T extends IResource> T create(String version, String kind, String name) {
        IResource resource = this.create(new ModelNode(), version, kind);
        ((KubernetesResource)resource).setName(name);
        return (T)resource;
    }

    private IResource create(ModelNode node, String version, String kind) {
        try {
            node.get(APIVERSION).set(version);
            node.get(KIND).set(kind.toString());
            Map<String, String[]> properyKeyMap = ResourcePropertiesRegistry.getInstance().get(version, kind);
            if (kind.endsWith("List")) {
                return new List(node, this.client, properyKeyMap);
            }
            Class<? extends IResource> klass = this.getResourceClass(version, kind);
            if (klass != null) {
                Constructor<? extends IResource> constructor = klass.getConstructor(ModelNode.class, IClient.class, Map.class);
                return constructor.newInstance(node, this.client, properyKeyMap);
            }
            return new KubernetesResource(node, this.client, properyKeyMap);
        }
        catch (UnsupportedVersionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ResourceFactoryException((Throwable)e, "Unable to create %s resource kind %s from %s", version, kind, node);
        }
    }

    private Class<? extends IResource> getResourceClass(String version, String kind) {
        if (IMPL_MAP.containsKey(kind)) {
            return IMPL_MAP.get(kind);
        }
        IApiTypeMapper mapper = this.client.adapt(IApiTypeMapper.class);
        if (mapper != null) {
            IApiTypeMapper.IVersionedApiResource endpoint = mapper.getEndpointFor(version, kind);
            String extension = "";
            switch (endpoint.getPrefix()) {
                case "api": 
                case "oapi": {
                    break;
                }
                default: {
                    String extPlusVersion = endpoint.getApiGroupName();
                    extension = StringUtils.split((String)extPlusVersion, (String)"/")[0];
                }
            }
            try {
                String classname = String.format("com.openshift.internal.restclient.%s%s.models.%s", endpoint.getPrefix(), extension, endpoint.getKind());
                return Class.forName(classname);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public <T extends IResource> T stub(String kind, String name, String namespace) {
        String version = this.client.getOpenShiftAPIVersion();
        KubernetesResource resource = (KubernetesResource)this.create(version, kind);
        resource.setName(name);
        resource.setNamespace(namespace);
        if (StringUtils.isNotEmpty((String)namespace)) {
            resource.setNamespace(namespace);
        }
        return (T)resource;
    }

    @Override
    public Object stubKind(String kind, Optional<String> name, Optional<String> namespace) {
        return this.stub(kind, name.get(), namespace.get());
    }

    @Override
    public <T extends IResource> T stub(String kind, String name) {
        return this.stub(kind, name, null);
    }

    @Override
    public void setClient(IClient client) {
        this.client = client;
    }

    static {
        IMPL_MAP.put("Build", Build.class);
        IMPL_MAP.put("BuildConfig", BuildConfig.class);
        IMPL_MAP.put("BuildRequest", BuildRequest.class);
        IMPL_MAP.put("DeploymentConfig", DeploymentConfig.class);
        IMPL_MAP.put("ImageStream", ImageStream.class);
        IMPL_MAP.put("ImageStreamImport", ImageStreamImport.class);
        IMPL_MAP.put("List", List.class);
        IMPL_MAP.put("OAuthAccessToken", OAuthAccessToken.class);
        IMPL_MAP.put("OAuthAuthorizeToken", OAuthAuthorizeToken.class);
        IMPL_MAP.put("OAuthClient", OAuthClient.class);
        IMPL_MAP.put("OAuthClientAuthorization", OAuthClientAuthorization.class);
        IMPL_MAP.put("Project", Project.class);
        IMPL_MAP.put("ProjectRequest", OpenshiftProjectRequest.class);
        IMPL_MAP.put("Policy", OpenshiftPolicy.class);
        IMPL_MAP.put("PolicyBinding", PolicyBinding.class);
        IMPL_MAP.put("Role", OpenshiftRole.class);
        IMPL_MAP.put("RoleBinding", RoleBinding.class);
        IMPL_MAP.put("Route", Route.class);
        IMPL_MAP.put("Template", Template.class);
        IMPL_MAP.put("User", OpenShiftUser.class);
        IMPL_MAP.put("Event", KubernetesEvent.class);
        IMPL_MAP.put("LimitRange", LimitRange.class);
        IMPL_MAP.put("Pod", Pod.class);
        IMPL_MAP.put("PersistentVolumeClaim", PersistentVolumeClaim.class);
        IMPL_MAP.put("PersistentVolume", PersistentVolume.class);
        IMPL_MAP.put("ResourceQuota", ResourceQuota.class);
        IMPL_MAP.put("ReplicationController", ReplicationController.class);
        IMPL_MAP.put("Status", Status.class);
        IMPL_MAP.put("Service", Service.class);
        IMPL_MAP.put("Secret", Secret.class);
        IMPL_MAP.put("ServiceAccount", ServiceAccount.class);
        IMPL_MAP.put("ConfigMap", ConfigMap.class);
        IMPL_MAP.put("Unrecognized", KubernetesResource.class);
    }
}

