/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IBuildTriggerable;
import com.openshift.restclient.model.IBuild;
import com.openshift.restclient.model.IBuildConfig;
import com.openshift.restclient.model.IResource;
import com.openshift.restclient.model.build.IBuildRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class BuildTrigger
implements IBuildTriggerable {
    private static final String BUILDCONFIG_SUBRESOURCE = "instantiate";
    private static final String BUILD_SUBRESOURCE = "clone";
    private IResource resource;
    private IClient client;
    private final String subresource;
    private String commitId;
    private List<String> causes;
    private HashMap<String, String> envVars = new HashMap();

    public BuildTrigger(IBuildConfig buildConfig, IClient client) {
        this.resource = buildConfig;
        this.client = client;
        this.subresource = BUILDCONFIG_SUBRESOURCE;
        this.causes = new ArrayList<String>();
    }

    public BuildTrigger(IBuild build, IClient client) {
        this.resource = build;
        this.client = client;
        this.subresource = BUILD_SUBRESOURCE;
        this.causes = new ArrayList<String>();
    }

    @Override
    public boolean isSupported() {
        return this.resource != null && this.client != null && ("Build".equals(this.resource.getKind()) || "BuildConfig".equals(this.resource.getKind()));
    }

    @Override
    public String getName() {
        return BuildTrigger.class.getSimpleName();
    }

    @Override
    public IBuild trigger() {
        IBuildRequest request = (IBuildRequest)this.client.getResourceFactory().stub("BuildRequest", this.resource.getName());
        if (StringUtils.isNotEmpty((String)this.commitId)) {
            request.setCommitId(this.commitId);
        }
        this.causes.forEach(c -> request.addBuildCause((String)c));
        this.envVars.forEach((name, value) -> request.setEnvironmentVariable((String)name, (String)value));
        return (IBuild)this.client.create(this.resource.getKind(), this.resource.getNamespace(), this.resource.getName(), this.subresource, request);
    }

    @Override
    @Deprecated
    public IBuild trigger(String commitId) {
        IBuildRequest request = (IBuildRequest)this.client.getResourceFactory().stub("BuildRequest", this.resource.getName());
        request.setCommitId(commitId);
        return (IBuild)this.client.create(this.resource.getKind(), this.resource.getNamespace(), this.resource.getName(), this.subresource, request);
    }

    @Override
    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    @Override
    public String getCommitId() {
        return this.commitId;
    }

    @Override
    public void addBuildCause(String cause) {
        this.causes.add(cause);
    }

    @Override
    public List<String> getBuildCauses() {
        return new ArrayList<String>(this.causes);
    }

    @Override
    public void setEnvironmentVariable(String name, String value) {
        this.envVars.put(name, value);
    }
}

