/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.capability.resources;

import com.openshift.restclient.IClient;
import com.openshift.restclient.capability.resources.IProjectTemplateList;
import com.openshift.restclient.model.IProject;
import com.openshift.restclient.model.template.ITemplate;
import java.util.Collection;

public class ProjectTemplateListCapability
implements IProjectTemplateList {
    private static final String COMMON_NAMESPACE = "openshift";
    private IProject project;
    private IClient client;

    public ProjectTemplateListCapability(IProject project, IClient client) {
        this.project = project;
        this.client = client;
    }

    @Override
    public boolean isSupported() {
        return this.client != null && this.project != null;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Collection<ITemplate> getTemplates() {
        return this.client.list("Template", this.project.getNamespace());
    }

    @Override
    public Collection<ITemplate> getCommonTemplates() {
        return this.getCommonTemplates(COMMON_NAMESPACE);
    }

    @Override
    public Collection<ITemplate> getCommonTemplates(String clusterNamespace) {
        return this.client.list("Template", clusterNamespace == null ? COMMON_NAMESPACE : clusterNamespace);
    }
}

