/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.restclient.model.image;

import com.openshift.internal.restclient.model.ModelNodeAdapter;
import com.openshift.internal.restclient.model.ObjectReference;
import com.openshift.internal.restclient.model.properties.ResourcePropertyKeys;
import com.openshift.internal.util.JBossDmrExtentions;
import com.openshift.restclient.model.IObjectReference;
import com.openshift.restclient.model.image.ITagReference;
import java.util.HashMap;
import java.util.Map;
import org.jboss.dmr.ModelNode;

public class TagReference
extends ModelNodeAdapter
implements ITagReference,
ResourcePropertyKeys {
    private static final String TAG_ANNOTATIONS = "annotations";

    public TagReference(String name, String fromKind, String fromName) {
        super(new ModelNode(), new HashMap<String, String[]>());
        this.setName(name);
        ObjectReference from = (ObjectReference)this.getFrom();
        from.setKind(fromKind);
        from.setName(fromName);
    }

    public TagReference(String name, String fromKind, String fromName, String fromNamespace) {
        this(name, fromKind, fromName);
        ObjectReference from = (ObjectReference)this.getFrom();
        from.setNamespace(fromNamespace);
    }

    public TagReference(ModelNode node, Map<String, String[]> propertyKeys) {
        super(node, propertyKeys);
    }

    @Override
    public boolean isAnnotatedWith(String key) {
        return this.getAnnotations().containsKey(key);
    }

    @Override
    public String getAnnotation(String key) {
        return this.getAnnotations().get(key);
    }

    @Override
    public void setAnnotation(String key, String value) {
        if (value == null) {
            return;
        }
        ModelNode annotations = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), TAG_ANNOTATIONS);
        annotations.get(key).set(value);
    }

    @Override
    public Map<String, String> getAnnotations() {
        return JBossDmrExtentions.asMap(this.getNode(), this.getPropertyKeys(), TAG_ANNOTATIONS);
    }

    @Override
    public String getName() {
        return JBossDmrExtentions.asString(this.getNode(), this.getPropertyKeys(), "name");
    }

    public void setName(String name) {
        JBossDmrExtentions.set(this.getNode(), this.getPropertyKeys(), "name", name);
    }

    @Override
    public IObjectReference getFrom() {
        ModelNode from = JBossDmrExtentions.get(this.getNode(), this.getPropertyKeys(), "from");
        return new ObjectReference(from);
    }
}

