/*
 * Decompiled with CFR 0.152.
 */
package com.orgzly.org.datetime;

import com.orgzly.org.datetime.OrgDateTime;
import com.orgzly.org.datetime.OrgInterval;
import com.orgzly.org.datetime.OrgRepeater;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;

public class OrgDateTimeUtils {
    private static final int MAX_INSTANTS_IN_INTERVAL = 100;

    public static DateTime getFirstWarningTime(int timeType, OrgDateTime orgDateTime, ReadableInstant fromTime, ReadableInstant beforeTime, OrgInterval defaultTimeOfDay, OrgInterval defaultWarningPeriod) {
        List<DateTime> times = OrgDateTimeUtils.getTimesInInterval(orgDateTime, fromTime, beforeTime, false, 1);
        Iterator<DateTime> iterator = times.iterator();
        if (iterator.hasNext()) {
            DateTime time = iterator.next();
            if (!orgDateTime.hasTime()) {
                time = time.plusHours(9);
            }
            return time;
        }
        return null;
    }

    public static List<DateTime> getTimesInInterval(OrgDateTime orgDateTime, ReadableInstant fromTime, ReadableInstant beforeTime, boolean useRepeater, int limit) {
        DateTime time = new DateTime((Object)orgDateTime.getCalendar());
        ArrayList<DateTime> result = new ArrayList<DateTime>();
        if (!useRepeater || !orgDateTime.hasRepeater() || orgDateTime.getRepeater().getValue() == 0) {
            if (!time.isBefore(fromTime) && (beforeTime == null || time.isBefore(beforeTime))) {
                result.add(time);
            }
        } else {
            if (beforeTime == null && limit == 0) {
                throw new IllegalArgumentException("When beforeTime is not specified, limit is mandatory");
            }
            if (limit > 100) {
                limit = 100;
            }
            OrgRepeater repeater = orgDateTime.getRepeater();
            DateTime curr = time;
            if (time.isBefore(fromTime)) {
                Interval gap = new Interval((ReadableInstant)time, fromTime);
                Period intervalPeriod = gap.toPeriod(OrgDateTimeUtils.getPeriodType(repeater.getUnit()));
                int units = intervalPeriod.getValue(0);
                int repeatTimes = units / repeater.getValue();
                int addUnits = repeater.getValue() * (repeatTimes + 1);
                curr = time.withFieldAdded(OrgDateTimeUtils.getDurationFieldType(repeater.getUnit()), addUnits);
            }
            while (beforeTime == null || curr.isBefore(beforeTime)) {
                result.add(curr);
                if (limit > 0 && result.size() >= limit) break;
                curr = curr.withFieldAdded(OrgDateTimeUtils.getDurationFieldType(repeater.getUnit()), repeater.getValue());
            }
        }
        return result;
    }

    private static PeriodType getPeriodType(OrgInterval.Unit unit) {
        switch (unit) {
            case HOUR: {
                return PeriodType.hours();
            }
            case DAY: {
                return PeriodType.days();
            }
            case WEEK: {
                return PeriodType.weeks();
            }
            case MONTH: {
                return PeriodType.months();
            }
            case YEAR: {
                return PeriodType.years();
            }
        }
        throw new IllegalArgumentException("Unknown unit " + (Object)((Object)unit));
    }

    private static DurationFieldType getDurationFieldType(OrgInterval.Unit unit) {
        switch (unit) {
            case HOUR: {
                return DurationFieldType.hours();
            }
            case DAY: {
                return DurationFieldType.days();
            }
            case WEEK: {
                return DurationFieldType.weeks();
            }
            case MONTH: {
                return DurationFieldType.months();
            }
            case YEAR: {
                return DurationFieldType.years();
            }
        }
        throw new IllegalArgumentException("Unknown unit " + (Object)((Object)unit));
    }
}

